% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_proper.R
\name{is.proper}
\alias{is.proper}
\alias{is.column.proper}
\alias{is.row.proper}
\title{Proper polynomial matrices}
\usage{
is.proper(pm)

is.column.proper(pm)

is.row.proper(pm)
}
\arguments{
\item{pm}{a polyMatrix object}
}
\value{
True if object \code{pm} is a (row-/column-) proper matrix
}
\description{
Tests the proper property of a polynomial matrix.
A polynomial matrix is proper if the associeted matrix has a full rank.
}
\details{
A polynomial matrix is column (row, full) proper (or reduced)
if the associated matrix has the same rank
as the number of columns (rows)
}
\section{Functions}{
\itemize{
\item \code{is.column.proper}: tests if its argument is a column-proper matrix

\item \code{is.row.proper}: tests if its argument is a row-proper matrix
}}

\examples{
pm <- parse.polyMatrix(
  "-1 + 7x     , x",
  " 3 - x + x^2, -1 + x^2 - 3 x^3"
)
is.column.proper(pm)
is.row.proper(pm)
is.proper(pm)

}
