% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\encoding{UTF-8}
\name{indicators}
\alias{indicators}
\title{Provide several polypharmacy indicators at once}
\usage{
indicators(
  processed_tab,
  stats = c("mean", "sd", "min", "p5", "p10", "p25", "median", "p75", "p90", "p95",
    "max"),
  method = c("ind_simult", "ind_stdcumul", "ind_wcumul", "ind_stdcontinuous",
    "ind_ucontinuous"),
  stdconti_pdays = 90,
  simult_ind_stats = c("mean", "min", "median", "max"),
  simult_calendar = FALSE,
  stdcumul_nPeriod = c(1, 3),
  cores = parallel::detectCores()
)
}
\arguments{
\item{processed_tab}{Name of the table of individual drug treatments to analyze. Created by the \code{\link{data_process}} function.}

\item{stats}{Polypharmacy cohort descriptive statistics to calculate on every polypharmacy indicator requested. See \emph{Details} for possible values.}

\item{method}{Names of the functions corresponding to each of the polypharmacy indicators to be calculated.. See \emph{Details} for possible values.}

\item{stdconti_pdays}{\code{pdays} argument of the \code{\link{ind_stdcontinuous}} function. Can contain multiple values. See \emph{examples}.}

\item{simult_ind_stats}{\code{stats} argument of the \code{\link{ind_simult}} function.}

\item{simult_calendar}{\code{TRUE} or \code{FALSE}. \code{calendar} argument of the \code{\link{ind_simult}} function.}

\item{stdcumul_nPeriod}{\code{nPeriod} argument of the \code{\link{ind_stdcumul}} function. Can contain multiple values. See \emph{examples}.}

\item{cores}{The number of CPU cores to use when executing \code{\link{ind_simult}}. See \code{\link[parallel]{detectCores}}.}
}
\value{
\code{list} of the values returned by every function listed in the \code{method} argument.
}
\description{
Wrapper function to run sequentially various polypharmacy functions on a single set of data. Each function corresponds to a different definition of polypharmacy.
}
\details{
\strong{stats & simult_ind_stats:} Possible values are
\itemize{
\item \code{'mean'}, \code{'min'}, \code{'median'}, \code{'max'}, \code{'sd'};
\item \code{'pX'} where \emph{X} is an integer value in ]0, 100];
\item \code{'q1'}=\code{'p25'}, \code{'q2'}=\code{'p50'}=\code{'median'}, \code{q3}=\code{'p75'}.
}

\strong{method:} Possible values are
\itemize{
\item \code{'ind_simult'} to assess polypharmacy based on the daily simultaneous consumption of medication.
\item \verb{'ind_stdcumul} to assess polypharmacy based on the cumulative number of distinct medications consumed over a given period of time (i.e. the standard definition).
\item \code{'ind_wcumul'} to assess polypharmacy based on the cumulative number of distinct medication consumed over a given period of time, weighted by the duration of consumption of each medication.
\item \code{'ind_stdcontinuous'} to assess polypharmacy based on the number of medications that are consumed both during the initial and the final period of the study period.
\item \code{'ind_ucontinuous'} to assess polypharmacy based on the uninterrupted consumption of distinct medications over the study period.
}
}
\examples{
\donttest{
dt_indic <- indicators(
  processed_tab = sample_Rx_processed,
  stats = c('mean', 'sd', 'min', 'p5', 'p10', 'p25', 'median', 'p75', 'p90', 'p95', 'max'),
  method = c('ind_simult', 'ind_stdcumul', 'ind_wcumul', 'ind_stdcontinuous', 'ind_ucontinuous'),
  stdconti_pdays = c(30, 90),
  simult_ind_stats = c('mean', 'min', 'median', 'max'),
  simult_calendar = TRUE,
  stdcumul_nPeriod = c(1, 3),
  cores = 1
)
}
}
