% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-class.R
\docType{class}
\name{pompp_model-class}
\alias{pompp_model-class}
\alias{names,pompp_model-method}
\alias{$,pompp_model-method}
\alias{$<-,pompp_model-method}
\alias{show,pompp_model-method}
\alias{print,pompp_model-method}
\alias{print.pompp_model}
\title{Class that defines a model for the pompp package.}
\usage{
\S4method{names}{pompp_model}(x)

\S4method{$}{pompp_model}(x, name)

\S4method{$}{pompp_model}(x, name) <- value

\S4method{show}{pompp_model}(object)

\S4method{print}{pompp_model}(x, ...)

\method{print}{pompp_model}(x, ...)
}
\arguments{
\item{x}{The pompp_model object.}

\item{name}{The requested slot.}

\item{value}{New value.}

\item{object}{The pompp_model object.}

\item{...}{Currently unused.}
}
\value{
\strong{\code{names}}: A character vector with possible options
for the \code{`$`} and \code{`$<-`} methods.

\strong{\code{`$`}}: The requested slot's value.

\strong{\code{`$<-`}}: The new object with the updated slot.

\strong{\code{show}} and \strong{\code{print}}: The invisible object.
}
\description{
The model includes the presence-only data, all selected variables, the link
functions for \eqn{q} and \eqn{p}, the initial values and the prior
distribution.
}
\section{Fields}{

\describe{
\item{\code{po}}{The matrix containing the covariates values for the data.}

\item{\code{intensityLink}}{A string informing about the chosen link for the
intensity covariates. Current acceptable choice is only \code{"logit"}.}

\item{\code{intensitySelection}}{A vector containing the indexes of the selected
intensity columns in the \code{po} matrix.}

\item{\code{observabilityLink}}{A string informing about the chosen link for the
observability covariates. Current acceptable choice is only \code{"logit"}.}

\item{\code{observabilitySelection}}{A vector containing the indexes of the selected
observability columns in the \code{po} matrix.}

\item{\code{marksSelection}}{A single value containing the index of the selected
marks column in the \code{po} matrix.}

\item{\code{coordinates}}{A vector of two values containing the column positions
of the longitude and latitude in the \code{po} matrix.}

\item{\code{init}}{A list with objects of class \code{pompp_initial} indicating
the initial values for each chain. The length of this list tells the program
how many chains are requested to be run.}

\item{\code{prior}}{An object of class \code{pompp_prior} which indicates the
joint prior distribution for the model parameters.}

\item{\code{iSelectedColumns}}{If the intensity covariates selection was made with
the name of the columns, they are stored in this slot.}

\item{\code{oSelectedColumns}}{If the observability covariates selection was made
with the name of the columns, they are stored in this slot.}

\item{\code{mSelectedColumns}}{If the marks selection was made
with the name of the column, it is stored in this slot.}
}}

\seealso{
\code{\link{pompp_initial-class}} and
\code{\link{pompp_prior-class}} and \code{\link{pompp_model}}
}
