% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{mymae}
\alias{mymae}
\title{Average absolute difference between allele frequencies computed from
genotypes supplied by the user and from Pool-seq data}
\usage{
mymae(
  genotypes,
  pools,
  pError,
  sError,
  mCov,
  vCov,
  min.minor,
  minimum = NA,
  maximum = NA
)
}
\arguments{
\item{genotypes}{a list of genotypes, where each entry is a matrix
corresponding to a different locus. At each matrix, each column is a
different SNP and each row is a different individual. Genotypes should be
coded as 0, 1 or 2.}

\item{pools}{a list with a vector containing the size (in number of diploid
individuals) of each pool. Thus, if a population was sequenced using a
single pool, the vector should contain only one entry. If a population was
sequenced using two pools, each with 10 individuals, this vector should
contain two entries and both will be 10.}

\item{pError}{an integer representing the value of the error associated with
DNA pooling. This value is related with the unequal contribution of both
individuals and pools towards the total number of reads observed for a
given population - the higher the value the more unequal are the individual
and pool contributions.}

\item{sError}{a numeric value with error rate associated with the sequencing
and mapping process. This error rate is assumed to be symmetric:
error(reference -> alternative) = error(alternative -> reference). This
number should be between 0 and 1.}

\item{mCov}{an integer that defines the mean depth of coverage to simulate.
Please note that this represents the mean coverage across all sites.}

\item{vCov}{an integer that defines the variance of the depth of coverage
across all sites.}

\item{min.minor}{is an integer representing the minimum allowed number of
minor-allele reads. Sites that, across all populations, have less
minor-allele reads than this threshold will be removed from the data.}

\item{minimum}{an optional integer representing the minimum coverage allowed.
Sites where the population has a depth of coverage below this threshold are
removed from the data.}

\item{maximum}{an optional integer representing the maximum coverage allowed.
Sites where the population has a depth of coverage above this threshold are
removed from the data.}
}
\value{
a data.frame with columns detailing the number of diploid
individuals, the pool error, the number of pools, the number of individuals
per pool, the mean coverage, the variance of the coverage and the average
absolute difference between the frequencies computed from genotypes and
from pooled data.
}
\description{
Calculates the average absolute difference between the allele frequencies
computed directly from genotypes and from pooled sequencing data. The
genotypes used should be supplied by the user and can be simulated using
different software and under the demographic model of choice.
}
\details{
The average absolute difference is computed with the \link[Metrics]{mae}
function, assuming the frequencies computed directly from the genotypes as
the \code{actual} input argument and the frequencies from pooled data as the
\code{predicted} input argument.

Note that this functions allows for different combinations of parameters.
Thus, the effect of different combinations of parameters on the average
absolute difference can be tested. For instance, it is possible to check what
is the effect of different coverages by including more than one value in the
\code{mCov} input argument. This function will run and compute the average
absolute difference for all combinations of the \code{pools}, \code{pError}
and \code{mCov} input arguments.
}
\examples{
# 100 individuals sampled at a single locus
genotypes <- run_scrm(nDip = 100, nloci = 1, theta = 5)
# compute the mean absolute error assuming a coverage of 100x and two pools of 50 individuals each
mymae(genotypes = genotypes, pools = list(c(50, 50)), pError = 100, sError = 0.001,
mCov = 100, vCov = 250, min.minor = 0)

# 10 individuals sampled at 5 different loci
genotypes <- run_scrm(nDip = 10, nloci = 5, theta = 5)
# compute the mean absolute error assuming a coverage of 100x and one pool of 10 individuals
mymae(genotypes = genotypes, pools = list(10), pError = 100, sError = 0.001,
mCov = 100, vCov = 250, min.minor = 0)

}
