% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{remove_by_reads_matrix}
\alias{remove_by_reads_matrix}
\title{Apply a coverage-based filter to a matrix}
\usage{
remove_by_reads_matrix(reads, minimum, maximum, genotypes = NA)
}
\arguments{
\item{reads}{a matrix with the total depth of coverage. Each row of the
matrix should be the coverage of a different population and each column a
different site.}

\item{minimum}{an integer representing the minimum coverage allowed. Sites
where any population has a depth of coverage below this threshold are
removed from the data.}

\item{maximum}{an integer representing the maximum coverage allowed. Sites
where any population has a depth of coverage above this threshold are
removed from the data.}

\item{genotypes}{an optional matrix input with the genotypes. Each column of
the matrix should be a different site and each row a different individual.}
}
\value{
a matrix with the total depth of coverage minus the sites (i.e.
columns) where the coverage for any of the populations was below the
minimum or above the maximum. If genotypes were supplied, then the output
will be a list, with one entry per locus. Each entry will contain the
filtered coverage in the first entry and the genotypes, minus the removed
sites, in the second entry.
}
\description{
This function removes sites that have a coverage below a \code{minimum} value and
sites with a coverage above a \code{maximum} value. If a matrix of genotypes is
also supplied, then those same sites are also removed from that matrix.
}
\examples{
set.seed(10)

# simulate coverage for a single locus - select the first entry to obtain a matrix
reads <- simulateCoverage(mean = c(25, 25), variance = c(200, 200), nSNPs = 10, nLoci = 1)[[1]]

# check the coverage matrix
reads

# remove sites with coverage below 10x or above 100x
remove_by_reads_matrix(reads = reads, minimum = 10, maximum = 100)

}
