% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.F4ratio.R
\name{compute.f4ratio}
\alias{compute.f4ratio}
\title{Compute F4ratio (estimation of admixture rate) from an fstats object}
\usage{
compute.f4ratio(x, num.quadruplet, den.quadruplet)
}
\arguments{
\item{x}{A fstats object containing estimates of fstats}

\item{num.quadruplet}{A character string for the F4 quadruplet used in the F4ratio numerator (should be of the form "A,O;C,X" where A, O, C and X are the names of the population as defined in the countdata or pooldata object used to obtain fstats, see details)}

\item{den.quadruplet}{A character string for the F4 quadruplet used in the F4ratio denominator (should be of the form "A,O;C,B" where A, O, C and B are the names of the populations as defined in the countdata or pooldata object used to obtain fstats, see details))}
}
\value{
A vector with 5 elements corresponding. The first element is always the estimated value. If F2 block-jackknife samples are available in the input fstats object (i.e., compute.fstats was run with return.F2.blockjackknife.samples = TRUE), the four other elements are the block-jackknife mean; the block-jackknife s.e.; and the lower and upper bound of the 95% (block-jackknife) Confidence Interval estimates. Otherwise these four elements are set to NA.
}
\description{
Compute F4ratio (estimation of admixture rate) from an fstats object
}
\details{
Assuming a 4 population phylogeny rooted with an outgroup O of the form (((A,B);C);O) and an admixed population X with two source populations related to B and C, the admixture rate alpha of the B-related ancestry is obtained using the ratio F4(A,O;C,X)/F4(A,O;C,B) (see Patterson et al., 2012 for more details).
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 res.fstats=compute.fstats(pooldata)
}
\seealso{
To generate pooldata object, see \code{\link{vcf2pooldata}}, \code{\link{popsync2pooldata}},\code{\link{genobaypass2pooldata}} or \code{\link{genoselestim2pooldata}}. To generate coundata object, see \code{\link{genobaypass2countdata}} or \code{\link{genotreemix2countdata}}.
}
