% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupClustering.R
\name{KruskalWallisAllPvalues}
\alias{KruskalWallisAllPvalues}
\title{Calculates all p-values of pairwise comparisons using a Kruskal-Wallis test}
\usage{
KruskalWallisAllPvalues(y, g, padjust = "fdr")
}
\arguments{
\item{y}{is a vector with the response}

\item{g}{is a single classification factor}

\item{padjust}{the method for adjusting for multiple comparisons following
the convention of the functions stats::p. adjust(default = "fdr"), NULL or
"none" does not adjust}
}
\value{
a vector with the p-values for comparing all the possible pairs.
}
\description{
Calculates all p-values of pairwise comparisons using a Kruskal-Wallis test
}
\examples{
KruskalWallisAllPvalues(y = DeIdentifiedExample$Y,
                                  g = DeIdentifiedExample$Treatment)
}
\author{
Rodrigo Labouriau
}
