% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LD.heatmap.R
\name{LD.heat.map}
\alias{LD.heat.map}
\title{Generates heat-maps for four linkage disequilibrium (LD) values ({D'}, {Wn}, {WLoc1/Loc2} and {WLoc2/Loc1}) generated for all pairs of phased and unphased two-locus haplotypes by LDWrap().}
\usage{
LD.heat.map(
  dataName = "",
  phasedData = "",
  unphasedData = "",
  phasedLabel = "Phased",
  unphasedLabel = "EM-estimated",
  color = TRUE,
  writePlot = FALSE,
  writeDir = tempdir()
)
}
\arguments{
\item{dataName}{The "base" name of the _LD_result.csv files generated by LDWrap() without the "_Phased_LD_results.csv" or "_Unphased_LD_results.csv" suffixes. See Examples, below. If both corresponding "<dataName>_Phased_LD_results.csv" and "<dataName>_Unphased_LD_results.csv" files are not found, the funciton will halt with a notification. However, if only one of those files is found in the working director, half-matrix heat map plots will be generated.}

\item{phasedData}{The complete name of a file of phased LD results generated by LDWrap(). Provide this filename if no base name is provided for dataName and you want to generate heat-maps for a specific set of phased LD values.}

\item{unphasedData}{The complete name of a file of unphased LD results generated by LDWrap(). Provide this filename if no base name is provided for dataName and you want to generate heat-maps for a specific set of unphased LD values.}

\item{phasedLabel}{The label that should appear on the heat-map plots for the upper, phased half of the plot. The default option is 'Phased'.}

\item{unphasedLabel}{The label that should appear on the heat-map plots for the lower, unphased half of the plot. The default option is 'EM-estimated'.}

\item{color}{A logical parameter that identifies if the heat-maps should be plotted in color (TRUE) or greyscale (FALSE). The default option is TRUE.}

\item{writePlot}{A logical parameter that identifies if the heat-map plots should be automatically saved after they are generated. The default is 'writePlot=FALSE'.}

\item{writeDir}{The directory into which the heat-map plots should be saved when 'writePlot=TRUE'. The default is the directory specified by tempdir().}
}
\description{
This function accepts *_LD_results.csv files generated by LDWrap() as input, and generates a PNG-formatted heat-map plot file for each LD measure.
}
\examples{
# Using the results of LDWrap() for the first 10 rows of the drb1.dqb1.demo dataset.
# Results are saved in the temporary directory as 
# "hla-family-data_Phased_LD_results.csv" and 
# "hla-family-data_Unphased_LD_results.csv", respectively.
LDWrap(drb1.dqb1.demo[1:10,])
LDWrap(drb1.dqb1.demo[1:10,],phased=FALSE)
exampleData <- paste(tempdir(),"hla-family-data",sep=.Platform$file.sep)
LD.heat.map(exampleData)
# Alternatively, these files can be sepcified individually to generate a half-matrix. 
LD.heat.map(phasedData=paste(exampleData,"_Phased_LD_results.csv",sep=""),unphasedLabel="")
# Further, two different sets of results for the same loci can be plotted; e.g., using
# phasedData="my_Phased_LD_results.csv" and unphasedData="your_Phased_LD_results.csv".
}
\references{
Osoegawa et al. Hum Immunol. 2019;80(9):644 https://doi.org/10.1016/j.humimm.2019.05.018
}
\keyword{disequilibrium}
\keyword{heat}
\keyword{heat-map}
\keyword{heatmap}
\keyword{linkage}
\keyword{map}
