% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poweRbal_data-methods.R
\name{print.poweRbal_data}
\alias{print.poweRbal_data}
\alias{summary.poweRbal_data}
\title{Print and summary method for poweRbal_data objects}
\usage{
\method{print}{poweRbal_data}(x, ...)

\method{summary}{poweRbal_data}(object, ...)
}
\arguments{
\item{x}{An object of class \code{poweRbal_data}, which is a list containing
one mandatory element, \code{power}, and several optional elements:\cr
\itemize{
\item \code{power}: A numeric matrix containing the power values (one row per
TSS and one column per alternative model).\cr
\item \code{accept_regions}: A numeric matrix containing information on the
region of acceptance (one row per TSS and four columns).\cr
\item \code{CIradius}: A numeric matrix containing the confidence interval
radii (one row per TSS and one column per alternative model).\cr
\item \code{actual_sample_sizes}: A numeric vector containing the actual sample
sizes under each alternative model, as some models do not always
successfully generate trees.\cr
\item \code{alt_model_params}: A numeric vector (one element per alternative
model) containing the values of a tree model parameter. This is only
suitable if the alternative models all belong to the same tree model
family and differ only in one parameter.\cr
\item Other input data from the \code{powerComp()} function, such as \code{tss},
\code{null_model}, \code{alt_models}, \code{n}, \code{distribs},
\code{N_null}, \code{N_alt}, \code{test_type}, \code{correction}, and
\code{sig_lvl}.
}}

\item{...}{Additional arguments passed to the \code{print} or \code{summary}
function.}

\item{object}{An object of class \code{poweRbal_data} (see \code{x} for
more details).}
}
\value{
\code{print.poweRbal_data} No return value, as the primary purpose
of this function is the side effect (printing).

\code{summary.poweRbal_data} No return value, as the primary purpose
of this function is the side effect (printing summary).
}
\description{
This function prints the contents of an object of class \code{poweRbal_data}.
It provides a brief summary of the object structure and its contents.

This function provides a summary of an object of class \code{poweRbal_data}.
It offers a high-level overview of the contents and their structure.
}
\examples{
# Printing a 'poweRbal_data' object:
pc1 <- powerComp(tss = c("Sackin", "Colless", "B1I"),
                 alt_models = list(list("aldous",-1), "pda", "etm"),
                 n = 8L, N_null = 40L, N_alt = 20L)
pc1
# Summary of a 'poweRbal_data' object:
summary(pc1)
}
