# -----------------------------------------------
# Generate a chronological or ordered p-plot from
# a vector of p-values. In case of a significant
# test at the end of the vector, the function
# further gives information of the number of
# oversampled datasets.
# -----------------------------------------------
pplot.pvals <- function(xs, ps, 
                      xtitle = "Observation",
                      alpha = 0.05,
                      n.sig = TRUE,
                      ylim.p = c(0,1),
                      pcol.alpha = 125) {
  
  # xs: vector of observations that the p values are computed on
  # ps: vector of p values
  # xtitle: title for x-axis (string)
  # alpha: significance threshold
  # n.sig: Show a vertical line before n_c/n_o in p-plot? (TRUE or FALSE)
  # ylim.p: y limits for p-plot; vector of min, max
  # pcol.alpha: transparency; set to 255 for solid fill
  #
  # Output: A number corresponding to n_c n_o, i.e., the
  #         amount of oversampling in a chronological or
  #         an ordered p-plot, respectively.
  
  # Misc settings
  #pcol <- rgb(117, 157, 197, maxColorValue = 255, alpha = 125, names = "rndteal")
  pcol <- rgb(117, 157, 197, maxColorValue = 255, alpha = pcol.alpha, names = "rndteal")
  
    # Do p-plot
      plot(xs,ps,pch = 21,col = pcol, type = "o",
           xlab= xtitle, ylab=expression(italic("p")*"-value"),
           ylim = ylim.p)
      points(xs,ps,pch = 16, col = "white")
      points(xs,ps,pch = 16, col = pcol)
      abline(h=alpha)
      
      # Add n_c/n_o
      plot.n.sig <- TRUE
      if (!n.sig) {
        plot.n.sig <- FALSE
      }
      n.sig <- -1
      
        if (ps[length(ps)]<=alpha) {
          isig <- length(ps)
          while (n.sig < 0) {
            isig <- isig - 1
            if (isig <= 1) {
              n.sig <- 1
            } else if (is.na(ps[isig])) {
              n.sig <- 1
            } else if (ps[isig]>alpha) {
              n.sig <- isig + 1
            }
          }
          if (n.sig > 0 & plot.n.sig) {
            abline(v=xs[n.sig])
          }
           
        }
      
      
      if (n.sig > 0) {
        n.sig.out <- xs[length(xs)]-xs[n.sig] 
      } else {
        n.sig.out <- -1
      }
      n.sig.out;
      }
    
  