% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.logis_re.R
\name{summary.logis_re}
\alias{summary.logis_re}
\title{Result Summaries of Covariate Estimates from a fitted \code{logis_re} object}
\usage{
\method{summary}{logis_re}(object, parm, level = 0.95, null = 0, ...)
}
\arguments{
\item{object}{a model fitted from \code{logis_re}.}

\item{parm}{specifies a subset of covariates for which the result summaries should be output.
By default, all covariates are included.}

\item{level}{the confidence level during the hypothesis test, meaning a significance level of \eqn{1 - \text{level}}.
The default value is 0.95.}

\item{null}{a number defining the null hypothesis for the covariate estimates. The default value is \code{0}.}

\item{\dots}{additional arguments that can be passed to the function.}
}
\value{
A data frame containing summary statistics for covariate estimates, with the following columns:
\item{Estimate}{the estimates of covariate coefficients.}
\item{Std.Error}{the standard error of the estimate.}
\item{Stat}{the test statistic.}
\item{p value}{the p-value for the hypothesis test.}
\item{CI.upper}{the lower bound of the confidence interval.}
\item{CI.lower}{the upper bound of the confidence interval.}
}
\description{
Provide the summary statistics for the covariate estimates for a random effect logistic model.
}
\examples{
data(ExampleDataBinary)
outcome <- ExampleDataBinary$Y
covar <- ExampleDataBinary$Z
ProvID <- ExampleDataBinary$ProvID
fit_re <- logis_re(Y = outcome, Z = covar, ProvID = ProvID)
summary(fit_re)

}
