% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWD_outlier.r
\name{PWD_outlier}
\alias{PWD_outlier}
\title{Weighted Deming Regression -- Outlier scanning}
\usage{
PWD_outlier(X, Y, K, lambda=1, Pcut=0.01, rho=NA, alpha=NA, beta=NA, mu=NA,
            printem=FALSE)
}
\arguments{
\item{X}{the vector of predicate readings.}

\item{Y}{the vector of test readings.}

\item{K}{the maximum number of outliers to seek.}

\item{lambda}{\emph{optional} (default of 1) - the ratio of the \code{X} to
the \code{Y} precision profile.}

\item{Pcut}{\emph{optional}, default 0.01 (1\%), cutoff for statistical significance of Bonferroni P.}

\item{rho}{\emph{optional} (default of NA) - numeric, single value or vector, initial estimate(s) of \eqn{\rho = \frac{\sigma}{\kappa}}.}

\item{alpha}{\emph{optional} (default of NA) - numeric, single value, initial estimate of \eqn{\alpha}.}

\item{beta}{\emph{optional} (default of NA) - numeric, single value, initial estimate of \eqn{\beta}.}

\item{mu}{\emph{optional} (default of NA) - numeric, vector of length of \code{X}, initial estimate of \eqn{\mu}.}

\item{printem}{\emph{optional} (default of FALSE) - if TRUE, routine will print out results as a \code{message}.}
}
\value{
A list containing the following components:

\item{ndrop}{the number of significant outliers}
\item{drop}{a vector of the indices of the outliers}
\item{cor }{the Pearson correlation between X and Y}
\item{cleancor }{the Pearson correlation between cleaned X and Y (after outliers removed)}
\item{scalr}{the scaled residuals of all cases from the sanitized fit and whose normal tail areas provide the basis for the outlier P values}
\item{keep}{logical vector identifying which cases retained in sanitized data set}
\item{basepar}{the sigma, kappa, alpha, beta of the full data set}
\item{lastpar}{the sigma, kappa, alpha, beta of the sanitized data set}
}
\description{
This function tests for outliers from the fitted regression, and refits on
a sanitized data set (with outliers removed).
}
\details{
The method is modeled on the Rosner sequential ESD outlier procedure and
assumes the sample is large enough to ignore the effect of random variability
in the parameter estimates on the distribution of the residuals.
}
\examples{
# library
library(ppwdeming)

# parameter specifications
sigma <- 1
kappa <- 0.08
alpha <- 1
beta  <- 1.1
true  <- 8*10^((0:99)/99)
truey <- alpha+beta*true
# simulate single sample - set seed for reproducibility
set.seed(1039)
# specifications for predicate method
X     <- sigma*rnorm(100)+true *(1+kappa*rnorm(100))
# specifications for test method
Y     <- sigma*rnorm(100)+truey*(1+kappa*rnorm(100))
# add some outliers
Y[c(1,2,100)] <- Y[c(1,2,100)] + c(7,4,-45)

# check for outliers, re-fit, and store output
\donttest{outliers_assess <- PWD_outlier(X, Y, K=5, printem=TRUE)}

}
\references{
Hawkins DM and Kraker JJ (in press). Precision Profile Weighted
Deming Regression for Methods Comparison. \emph{The Journal of Applied Laboratory Medicine}.
\url{doi:10.1093/jalm/jfaf183}

Hawkins DM (2008). \emph{Outliers} in Wiley Encyclopedia of Clinical Trials,
eds R. D’Agostino, L. Sullivan, and J. Massaro. Wiley, New York.
}
\author{
Douglas M. Hawkins, Jessica J. Kraker \href{mailto:krakerjj@uwec.edu}{krakerjj@uwec.edu}
}
