% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_precisely.R
\name{plot_sample_size}
\alias{plot_sample_size}
\alias{plot_precision}
\alias{plot_upper_limit}
\title{Plot precisely}
\usage{
plot_sample_size(.df, xlab = "Sample Size", ylab = "Precision", line_size = 1)

plot_precision(.df, xlab = "Precision", ylab = "Sample Size", line_size = 1)

plot_upper_limit(
  .df,
  xlab = "Sample Size",
  ylab = "Upper Limit",
  line_size = 1
)
}
\arguments{
\item{.df}{a data frame with values to plot, possibly from \code{\link[=map_precisely]{map_precisely()}}.}

\item{xlab}{Label for the x-axis.}

\item{ylab}{Label for the y-axis.}

\item{line_size}{The width of the line. Default is 1.}
}
\value{
a ggplot
}
\description{
Simple line plots for the output of \code{\link[=map_precisely]{map_precisely()}}. Use
\code{\link[dplyr:group_by]{dplyr::group_by()}} to create multiple lines on the plot.
}
\examples{
library(dplyr)
library(ggplot2)

map_precisely(
  n_risk_difference,
  precision = seq(from = .02, to = .20, by = .005),
  exposed = .4,
  unexposed = .3,
  group_ratio = 1
 ) \%>\%
  plot_sample_size()

map_precisely(
  precision_odds_ratio,
  n_cases = seq(from = 500, to = 1000, by = 10),
  exposed_cases = .6,
  exposed_controls = .4,
  group_ratio = 1:4
) \%>\%
  group_by("Control/Case Ratio" = factor(group_ratio)) \%>\%
  plot_precision()

map_precisely(
  upper_rate_ratio,
  upper_limit = seq(1.5, 2.5, by = .1),
  prob = seq(.50, .95, by = .05),
  exposed = .01,
  unexposed = .01,
  group_ratio = 1:4
 ) \%>\%
  group_by("Probability" = factor(prob)) \%>\%
  plot_upper_limit(line_size = 1) +
    scale_color_viridis_d() +
    theme_precisely() +
    theme(legend.position = "right",
          strip.text = element_text(margin = margin(b = 5), hjust = 0)) +
    facet_wrap(~ group_ratio,
               labeller = as_labeller(function(x) paste("Unexposed/Exposed:", x)))


}
