% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE_continuous.R
\name{drmean}
\alias{drmean}
\title{Doubly robust estimator of the average treatment effect for continuous data}
\usage{
drmean(
  y,
  trt,
  x.cate,
  x.ps,
  ps.method = "glm",
  minPS = 0.01,
  maxPS = 0.99,
  interactions = TRUE
)
}
\arguments{
\item{y}{A numeric vector of size \code{n} with each element representing
the observed continuous outcome for each subject.}

\item{trt}{A numeric vector (in \{0, 1\}) of size \code{n} with each element
representing the treatment received for each subject.}

\item{x.cate}{A numeric matrix of dimension \code{n} by \code{p.cate} with
each column representing each baseline covariate specified in the outcome
model for all subjects.}

\item{x.ps}{A numeric matrix of dimension \code{n} by \code{p.ps + 1} with
a leading column of 1 as the intercept and each remaining column representing
each baseline covariate specified in the propensity score model for all
subjects}

\item{ps.method}{A character value for the method to estimate the propensity
score. Allowed values include one of:
\code{'glm'} for logistic regression with main effects only (default), or
\code{'lasso'} for a logistic regression with main effects and LASSO
penalization on two-way interactions (added to the model if interactions are
not specified in \code{ps.model}). Relevant only when \code{ps.model} has
more than one variable.}

\item{minPS}{A numerical value between 0 and 1 below which estimated propensity
scores should be truncated. Default is \code{0.01}.}

\item{maxPS}{A numerical value between 0 and 1 above which estimated propensity
scores should be truncated. Must be strictly greater than \code{minPS}.
Default is \code{0.99}.}

\item{interactions}{A logical value indicating whether the outcome model
should assume interactions between \code{x} and \code{trt}. If \code{TRUE},
interactions will be assumed only if at least 10 patients received each
treatment option. Default is \code{TRUE}.}
}
\value{
Return a list of 4 elements:
\itemize{
  \item{\code{mean.diff}: } A numeric value of the estimated mean difference.
  \item{\code{mean.diff0}: } A numeric value of the estimated mean difference
  in treatment group 0.
  \item{\code{mean.diff1}: } A numeric value of the estimated mean difference
  in treatment group 1.
}
}
\description{
Doubly robust estimator of the average treatment effect between two
treatments, which is the mean difference of treatment 1 over treatment 0 for
continuous outcomes.
}
