% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalized_stroopdata.R
\docType{data}
\name{finalized_stroopdata}
\alias{finalized_stroopdata}
\title{Finalized Table \code{prepdat::prep()} returns for \code{stroopdata} According to the
Example in \code{prepdat::prep()}.}
\format{A data frame with 15 rows and 98 columns.}
\usage{
data(finalized_stroopdata)
}
\description{
A data frame containing dependent measures \code{prep} for each \code{id}
 calculated according to grouping variables: block and target_type.
 \code{prep()} aggregates the columns for the dependent measures by first
 dividing them to the levels of the first independent variable in
 \code{wthin vars}, and then within each level \code{prep()} divides the columns
 according to the next variable in \code{within_vars} and so forth.
 Thus, for each dependent measure in this example there are four columns
 according to the order they where entered in \code{within_vars} argument in
 \code{prep}. For this data frame this argument was
 \code{within_vars = c("block", "target_type")}.
}
\details{
The complete list of names of the dependent measures is:

\code{mdvc}: mean \code{dvc}.

\code{sdvc}: SD for \code{dvc}.

\code{meddvc}: median \code{dvc}.

\code{tdvc}: mean \code{dvc} after rejecting observations above
     standard deviation criteria specified in \code{sd_criterion}.

\code{ntr}: number of observations rejected for each standard deviation
     criterion specified in \code{sd_criterion}.

\code{ndvc}: number of observations before rejection.

\code{ptr}: proportion of observations rejected for each standard
     deviation criterion specified in \code{sd_criterion}.

\code{rminv}: harmonic mean of \code{dvc}.

\code{prt}: \code{dvc} according to each of the percentiles specified
     in \code{percentiles}.

\code{mdvd}: mean \code{dvd}.

\code{merr}: mean error.

\code{nrmc}: mean \code{dvc} according to non-recursive procedure with
     moving criterion.

\code{nnrmc}: number of observations rejected for \code{dvc} according
     to non-recursive procedure with moving criterion.

\code{pnrmc}: percent of observations rejected for \code{dvc} according
     to non-recursive procedure with moving criterion.

\code{tnrmc}: total number of observations upon which the non-recursive
     procedure with moving criterion was applied.

\code{mrmc}: mean \code{dvc} according to modified-recursive procedure
     with moving criterion.

\code{nmrmc}: number of observations rejected for \code{dvc} according
     to modified-recursive procedure with moving criterion.

\code{pmrmc}: percent of observations rejected for \code{dvc} according
     to modified-recursive procedure with moving criterion.

\code{tmrmc}: total number of observations upon which the
     modified-recursive procedure with moving criterion was applied.

\code{hrmc}: mean \code{dvc} according to hybrid-recursive procedure
     with moving criterion.

\code{nhrmc}: number of observations rejected for \code{dvc} according
     to hybrid-recursive procedure with moving criterion.

\code{thrmc}: total number of observations upon which the
     hybrid-recursive procedure with moving criterion was applied.
}
\examples{
data(finalized_stroopdata)
head(finalized_stroopdata)
}
\keyword{datasets}

