% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorization.R
\name{ReducePrime}
\alias{ReducePrime}
\title{Get the Prime Factorization.}
\usage{
ReducePrime(code, out.summary = FALSE, primes.div = NULL)
}
\arguments{
\item{code}{A vector representing a number. See details.}

\item{out.summary}{Is the result to be summarized? For example,
(2, 3, 0, 0, 1) can be summarized as (2, 5; 3, 1). Default is \code{FALSE}.}

\item{primes.div}{The vector of all prime numbers
up to \code{sqrt(length(code))}. Default get them for you.}
}
\value{
Two rows representing prime numbers
}
\description{
Get the Prime Factorization for a number
with a particular coding.
}
\details{
A \code{code} is the coding of a number as follows,
\deqn{number = \prod i^{code[i]},}
or, which is equivalent,
\deqn{\log(number) = \sum code[i] * \log(i).}
For example, \itemize{
\item 5 is coded as (0, 0, 0, 0, 1),
\item 5! is coded as (1, 1, 1, 1, 1),
\item 8! is coded as (1, 1, 1, 1, 1, 1, 1, 1),
\item 8! / 5! is therefore coded as (0, 0, 0, 0, 0, 1, 1, 1),
\item 5! = 5 * 3 * 2^3 can be reduced to (0, 3, 1, 0, 1).
}
Note that the first element of a \code{code} has no effect.
}
\examples{
code100 <- c(rep(0, 99), 1)
ReducePrime(c(rep(0, 99), 1), out.summary = TRUE)
primes.div <- AllPrimesUpTo(floor(sqrt(length(code100))))
ReducePrime(c(rep(0, 99), 1), primes.div = primes.div)
}
