% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizationProblem-methods.R
\name{OptimizationProblem-methods}
\alias{OptimizationProblem-methods}
\alias{modelsense}
\alias{vtype}
\alias{obj}
\alias{A}
\alias{rhs}
\alias{sense}
\alias{lb}
\alias{ub}
\alias{col_ids}
\alias{row_ids}
\alias{compressed_formulation}
\alias{remove_last_linear_constraint}
\alias{set_obj}
\alias{set_lb}
\alias{set_ub}
\alias{append_linear_constraints}
\alias{ncell,OptimizationProblem-method}
\alias{A,OptimizationProblem-method}
\alias{col_ids,OptimizationProblem-method}
\alias{lb,OptimizationProblem-method}
\alias{modelsense,OptimizationProblem-method}
\alias{ncol,OptimizationProblem-method}
\alias{nrow,OptimizationProblem-method}
\alias{obj,OptimizationProblem-method}
\alias{rhs,OptimizationProblem-method}
\alias{row_ids,OptimizationProblem-method}
\alias{sense,OptimizationProblem-method}
\alias{ub,OptimizationProblem-method}
\alias{vtype,OptimizationProblem-method}
\alias{compressed_formulation,OptimizationProblem-method}
\alias{set_obj,OptimizationProblem,ANY-method}
\alias{set_obj,OptimizationProblem-method}
\alias{set_lb,OptimizationProblem,ANY-method}
\alias{set_lb,OptimizationProblem-method}
\alias{set_ub,OptimizationProblem,ANY-method}
\alias{set_ub,OptimizationProblem-method}
\alias{append_linear_constraints,OptimizationProblem,ANY,ANY,ANY,ANY-method}
\alias{append_linear_constraints,OptimizationProblem-method}
\alias{remove_last_linear_constraint,OptimizationProblem-method}
\title{Optimization problem methods}
\usage{
\S4method{nrow}{OptimizationProblem}(x)

\S4method{ncol}{OptimizationProblem}(x)

\S4method{ncell}{OptimizationProblem}(x)

modelsense(x)

\S4method{modelsense}{OptimizationProblem}(x)

vtype(x)

\S4method{vtype}{OptimizationProblem}(x)

obj(x)

\S4method{obj}{OptimizationProblem}(x)

A(x)

\S4method{A}{OptimizationProblem}(x)

rhs(x)

\S4method{rhs}{OptimizationProblem}(x)

sense(x)

\S4method{sense}{OptimizationProblem}(x)

lb(x)

\S4method{lb}{OptimizationProblem}(x)

ub(x)

\S4method{ub}{OptimizationProblem}(x)

col_ids(x)

\S4method{col_ids}{OptimizationProblem}(x)

row_ids(x)

\S4method{row_ids}{OptimizationProblem}(x)

compressed_formulation(x)

\S4method{compressed_formulation}{OptimizationProblem}(x)

set_obj(x, obj)

\S4method{set_obj}{OptimizationProblem,ANY}(x, obj)

set_lb(x, lb)

\S4method{set_lb}{OptimizationProblem,ANY}(x, lb)

set_ub(x, ub)

\S4method{set_ub}{OptimizationProblem,ANY}(x, ub)

append_linear_constraints(x, rhs, sense, A, row_ids)

\S4method{append_linear_constraints}{OptimizationProblem,ANY,ANY,ANY,ANY}(x, rhs, sense, A, row_ids)

remove_last_linear_constraint(x)

\S4method{remove_last_linear_constraint}{OptimizationProblem}(x)
}
\arguments{
\item{x}{\code{\link[=optimization_problem]{optimization_problem()}} object.}

\item{obj}{\code{numeric} vector containing a new linear coefficient for
each decision variable in the problem.}

\item{lb}{\code{numeric} vector containing a new lower bound for each
decision variable in the problem.}

\item{ub}{\code{numeric} vector containing a new upper bound for each
decision variable in the problem.}

\item{rhs}{\code{numeric} vector with the right-hand-side values for new
constraints.}

\item{sense}{\code{character} vector with senses for new constraints
(i.e., \code{">="}, \code{"<="}, or "\code{=}" values).}

\item{A}{\code{\link[Matrix:sparseMatrix]{Matrix::sparseMatrix()}} matrix with coefficients for new
constraints.}

\item{row_ids}{\code{character} vector with identifiers for new constraints.}
}
\value{
A \code{\link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix}}, \code{numeric} vector,
\code{numeric} vector, or scalar \code{integer} depending on the method
used.
}
\description{
These functions are used to query and update a \code{\link[=optimization_problem]{optimization_problem()}}.
}
\details{
The following functions are used to query data.

\describe{

\item{\code{nrow(x)}}{\code{integer} number of rows (constraints).}

\item{\code{ncol(x)}}{\code{integer} number of columns (decision variables).}

\item{\code{ncell(x)}}{\code{integer} number of cells.}

\item{\code{modelsense(x)}}{\code{character} describing if the problem is to be
maximized (\code{"max"}) or minimized (\code{"min"}).}

\item{\code{vtype(x)}}{\code{character} describing the type of each decision variable:
binary (\code{"B"}), semi-continuous (\code{"S"}), or continuous
(\code{"C"})}

\item{\code{obj(x)}}{\code{numeric} vector specifying the objective function.}

\item{\code{A(x)}}{\code{\link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix}} matrix object defining the
problem matrix.}

\item{\code{rhs(x)}}{\code{numeric} vector with right-hand-side linear constraints}

\item{\code{sense(x)}}{\code{character} vector with the senses of the linear
constraints (\code{"<="}, \code{">="}, \code{"="}).}

\item{\code{lb(x)}}{\code{numeric} lower bound for each decision variable. Missing data
values (\code{NA}) indicate no lower bound for a given variable.}

\item{\code{ub(x)}}{\code{numeric} upper bounds for each decision variable. Missing
data values (\code{NA}) indicate no upper bound for a given variable.}

\item{\code{number_of_planning_units(x)}}{\code{integer} number of planning units in
the problem.}

\item{\code{number_of_features(x)}}{\code{integer} number of features
the problem.}
}

The following functions are used to update data. Note that these
functions return an invisible \code{TRUE} indicating success.

\describe{
\item{\code{set_obj(x, obj)}}{override the objective in the problem.
Here, \code{obj} is a \code{numeric} vector containing a new linear coefficient for
each decision variable in the problem.}

\item{\code{set_lb(x, lb)}}{override the variable lower bounds in the problem.
Here, \code{lb} is a \code{numeric} vector containing a new lower bound.for each
decision variable in the problem.}

\item{\code{set_ub(x, ub)}}{override the variable upper bounds in the problem.
Here, \code{ub} is a \code{numeric} vector containing a new upper bound.for each
decision variable in the problem.}

\item{\code{remove_last_linear_constraint()}}{remove the last linear constraint
added to a problem.}

\item{\code{append_linear_constraints(x, A, sense, rhs, row_ids)}}{
add an additional linear constraints to a problem. Here,
\code{A} is a \code{\link[Matrix:sparseMatrix]{Matrix::sparseMatrix()}} matrix, \code{sense} is a
\code{character} vector with constraint senses (i.e., \code{">="}, \code{"<="}, or "\code{=}"
values), \code{rhs} is a \code{numeric} vector with the right-hand-side values,
and \code{row_ids} is a \code{character} vector with identifiers.}

}
}
