% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{subset.ps}
\alias{subset.ps}
\title{Subsets of Probability Spaces
 This is a method for \code{subset()} for the case when the input object is a probability space of class \code{ps}.}
\usage{
\method{subset}{ps}(x, subset, ...)
}
\arguments{
\item{x}{a probability space.}

\item{subset}{logical expression indicating elements or rows of \code{space} to keep: missing values are taken as false.}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
A \code{ps} object, a subset of a probability space.
}
\description{
Subsets of Probability Spaces
 This is a method for \code{subset()} for the case when the input object is a probability space of class \code{ps}.
}
\details{
This function simply extends the existing \code{subset()} function to \code{ps} objects.
}
\examples{
L <- tosscoin(2)
M <- urnsamples(L, 3)
N <- probspace(M)
subset(N, all(toss1=="H"))
subset(N, any(toss2=="T"))
}
\author{
G. Jay Kerns \email{gkerns@ysu.edu}.
}
