% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.R
\name{post_issue_update}
\alias{post_issue_update}
\title{Post updates to existing issue in GitHub repository}
\usage{
post_issue_update(ref, issue_number, ...)
}
\arguments{
\item{ref}{Repository reference (list) created by \code{create_repo_ref()}}

\item{issue_number}{Issue number}

\item{...}{Additional user-defined body parameters. Use \code{browse_docs()} to learn more.}
}
\value{
Number (identifier) of updated issue
}
\description{
Post updates to existing issue in GitHub repository
}
\examples{
\dontrun{
myrepo <- create_repo_ref('emilyriederer', 'myrepo')
post_issue_update(myrepo,
  issue_number = 1,
  labels = c('priority:high', 'bug'))
}
}
\seealso{
Other issues: 
\code{\link{get_issue_comments}()},
\code{\link{get_issue_events}()},
\code{\link{get_issues}()},
\code{\link{parse_issue_comments}()},
\code{\link{parse_issue_events}()},
\code{\link{parse_issues}()},
\code{\link{post_issue}()},
\code{\link{report_discussion}()},
\code{\link{report_progress}()},
\code{\link{viz_waterfall}()}
}
\concept{issues}
