% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IM_PSEHMM.R
\name{IM_psehmm}
\alias{IM_psehmm}
\title{IM_psehmm}
\usage{
IM_psehmm(hmm, d = 13)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}

\item{d}{The maximum distance between residues column-wise.}
}
\value{
A vector of length \eqn{20+20\times d-d\times\frac{d+1}{2}}
}
\description{
The first twenty numbers of this feature correspond to the means of each column of the HMM matrix
\eqn{H}. The rest of the features in the feature vector are found in matrix \eqn{T[i,j]}, where \eqn{T[i,j] =
\frac{1}{L-i}\sum_{n = 1}^{20-i} [H_{m,n}-H_{m, n+i}]^2, m = 1:L,\space i = 1:d\space and\space j = 1:20}.
}
\note{
d must be less than 20.
}
\examples{
h<- IM_psehmm(system.file("extdata", "1DLHA2-7", package="protHMM"))

}
\references{
Ruan, X., Zhou, D., Nie, R., & Guo, Y. (2020).
Predictions of Apoptosis Proteins by Integrating Different Features Based on Improving Pseudo-Position-Specific Scoring Matrix.
BioMed Research International, 2020, 1–13.
}
