% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.search.R
\name{tag.search}
\alias{tag.search}
\title{tag.search}
\usage{
tag.search(dataset, delta = NA, error.Da.pair = 0.5,
  error.Da.match = 0.5, error.ppm.pair = Inf, error.ppm.match = Inf,
  intens.log.transfrom = FALSE)
}
\arguments{
\item{dataset}{a tidy dataset containing the mass list. At least three numeric columns are required: "mass", "intensity" and "group". The "mass" refers to m/z values; "intensity" refers to peak height/area; "group" must contain the "control" observations.}

\item{delta}{a single numeric value, or a numeric vector when multiple m/z difference is of interest. The variable "delta" reflects the mass difference between the labelled proteins/peptides vs. the non-labelled (the control), caused by the chemically-labelling group.}

\item{error.Da.pair}{error tolerance for the paired peaks, in Dalton; default at 0.5.}

\item{error.Da.match}{error tolerance for the matched peaks, in Dalton; default at 0.5.}

\item{error.ppm.pair}{error tolerance threshold for the paired peaks, in ppm. For paired peaks p and q, the tolerance threshold is defined as 0.5 * (p+q) * error.ppm.pair / 10^6. When the absolute difference between the measured vs. theoretical delta is lower than the error tolerance, then the associated two peaks are considered a pair. The default value of error.ppm.pair is Inf (positive infinite); that is, the error tolerance by default is controled by error.Da.pair. When error.ppm.pair is otherwise set, say at 100 (ppm), then the practical error tolerance value is the smallest of either the Dalton control or ppm control. When the ppm control is more desirable than Dalton control, consider setting error.Da.pair = Inf.}

\item{error.ppm.match}{error tolerance for the matched peaks, in ppm. Error tolerance control for matched peaks is similar to the case of paired peaks.}

\item{intens.log.transfrom}{default to FALSE. If set to TRUE, peak intensities will be logarithmically transformed. This is useful for displaying low-intensity peaks that would otherwise be overshadowed and less visible in the mass spectra.}
}
\value{
a tidy dataset, with the original input dataset augmented with additional columns. The content in the input dataset remain unchanged (though the display sequence may change).
}
\description{
This function takes a mass list dataset containing columns of "mass", "intensity" and "group" (contains the "control" observations) , and searches within specified error tolerance for "paired" peaks, "matched" peaks, and "mismatched" peaks. Mass spectra peaks with m/z diffrence being the designated variable "delta" (within error tolerance) are defined as a "pair", and peaks of the same m/z (within error tolerance) as "match"; otherwise defined as "mismatch".
}
\examples{
search.result <- tag.search(myoglobin, delta = c(14, 28), error.Da.pair = .3)
search.result
tag.spectra.listplot(search.result)
}
