% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.spectra.listplot.R
\name{tag.spectra.listplot}
\alias{tag.spectra.listplot}
\title{tag.spectra.listplot}
\usage{
tag.spectra.listplot(search.output.list, show.peak.pair = TRUE,
  show.peak.match = TRUE, show.peak.mismatch = TRUE,
  show.annotation.pair = TRUE, show.annotation.match = TRUE,
  show.annotation.mismatch = FALSE, size.peak.pair = 2,
  size.peak.match = 1, size.peak.mismatch = 0.5, size.divider = 0.3,
  size.annotation.pair = NA, size.annotation.match = NA,
  size.annotation.mismatch = NA, size.groupname = NA,
  alpha.peak.pair = 0.8, alpha.peak.match = 0.5,
  alpha.peak.mismatch = 0.2, alpha.annotation.pair = 0.8,
  alpha.annotation.match = 0.5, alpha.annotation.mismatch = 0.2,
  color.pair = 1, color.match = "black", color.mismatch = "black",
  color.groupname = "black", color.divider = "black",
  angle.annotation = 90, angle.groupname = 90, gap.groupname = 0.02,
  gap.annotation = 0.15, peak.height.shrink = 0.7)
}
\arguments{
\item{search.output.list}{the output list from function tag.search}

\item{show.peak.pair}{if TRUE, show the paired peaks}

\item{show.peak.match}{if TRUE, show the matched peaks}

\item{show.peak.mismatch}{if TRUE, show the mismatched peaks}

\item{show.annotation.pair}{if TRUE, show the m/z annotations for the paired peaks}

\item{show.annotation.match}{if TRUE, show the m/z annotations for the mathced peaks}

\item{show.annotation.mismatch}{if TRUE, show the m/z annotations for the mismatched peaks}

\item{size.peak.pair}{adjust the peak width of the paired peaks. All size.xxx arguments take a numeric value, same functionality as line width or text size control in ggplot2}

\item{size.peak.match}{adjust the peak width of the matched peaks}

\item{size.peak.mismatch}{adjust the peak width of the mismatched peaks}

\item{size.divider}{adjust divider width}

\item{size.annotation.pair}{adjust the m/z annotation text size for the paired peaks}

\item{size.annotation.match}{adjust the m/z annotation text size for the matched peaks}

\item{size.annotation.mismatch}{adjust the m/z annotation text size for the mismatched peaks}

\item{size.groupname}{adjust the text size for groupnames (e.g., "control", "experiment1", "experiment2", etc.).}

\item{alpha.peak.pair}{adjust the transparency of the paired peaks. All alpha.xxx arguments take a numeric value [0,1]}

\item{alpha.peak.match}{adjust the transparency of the matched peaks}

\item{alpha.peak.mismatch}{adjust the transparency of the mismatched peaks}

\item{alpha.annotation.pair}{adjust the transparency of the m/z annotations for the paired peaks}

\item{alpha.annotation.match}{adjust the transparency of the m/z annotations for the matched peaks}

\item{alpha.annotation.mismatch}{adjust the transparency of the m/z annotations for the mismatched peaks}

\item{color.pair}{control the color for the paired peaks and the associated m/z annotations. Each pair will be of the same color, and different pairs of differentiating colors. In case of multiple mass shifts being of interest within a pair, e.g., delta = c(14, 28, 56), then peaks with m/z difference of either 14, 28 or 56, all belonging to the same pair, will be of the same color.  Apart from the default color set, users could otherwise choose color from RColorBrewer palettes, e.g., color.pair = "Set1", or color.pair = "Blues".

Colors for peaks (paired, matched, and mismatched) and the respectively associated annotations are designed to be of the same set of color for maximum clarity.}

\item{color.match}{control the color for the matched peaks with the associated m/z annotations, with default in "black". Users may otherwise reset to different colors, e.g., color.match = "firebrick". As the matched peaks and mismatched peaks are usually of less research interest than paired peaks, the matched and mismatched peaks are respectively designed to be of monocolor.}

\item{color.mismatch}{control the color for the mismatched peaks with the associated m/z annotations, with default in "black".}

\item{color.groupname}{control the color for the groupnames, with default in "black".}

\item{color.divider}{control the color of the central divider}

\item{angle.annotation}{adjust the angle for the m/z annotations, taking a numeric value. This argument is useful to avoid annotation overlap, and is particularly handy when the plot is reoriented with coord_flip().}

\item{angle.groupname}{adjust the angle of the groupnames.}

\item{gap.groupname}{adjust the horizontal position of groupnames. A positive numeric value adjusts the distance between groupnames and the left bound of the mass spectra; negative values shifts the groupnames to the right side.}

\item{gap.annotation}{adjust the distance between m/z annotations and the top of the peak.}

\item{peak.height.shrink}{Taking a numeric value [0, 1], a small shrinking factor renders smaller peak height, and generates more space between peak and the central divider, leaving more space for annotations. This argument resolves overlap among annotations with upper-floor-residing peaks, a problem unique to listplot. Therefore, this argument is not used in the butterflyplot.}
}
\value{
a ggplot2 plot.
}
\description{
This function takes the output dataset from tag.search, and draw using ggplot2 the centroid mass spectra displayed in a listed manner. Peaks from the same "pair" (with designated m/z difference) are highlighted in differentiating colors, distinguished away from peaks of the "match" (with the same m/z) and the "mismatch" (neither of the prior two cases).
}
\details{
This function is designed for comparison of multiple mass spectra. In case of comparison of two mass spectra, it is recommended to use tag.spectra.butterflyplot for the highest annotation clarity.
}
\examples{
search.result <- tag.search(myoglobin, delta = c(14, 28), error.Da.pair = .3)
search.result
tag.spectra.listplot(search.result)
}
