/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.table;

import com.qarks.util.ui.swing.table.SingleObjectTableColumn;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class SingleObjectTableModel
extends AbstractTableModel {
    protected ArrayList objects = new ArrayList();
    private SingleObjectTableColumn[] columns = new SingleObjectTableColumn[0];

    public void addColumn(SingleObjectTableColumn singleObjectTableColumn) {
        SingleObjectTableColumn[] singleObjectTableColumnArray = new SingleObjectTableColumn[this.columns.length + 1];
        for (int i = 0; i < this.columns.length; ++i) {
            singleObjectTableColumnArray[i] = this.columns[i];
        }
        singleObjectTableColumn.setModelIndex(this.columns.length);
        singleObjectTableColumnArray[this.columns.length] = singleObjectTableColumn;
        this.columns = singleObjectTableColumnArray;
    }

    @Override
    public int getRowCount() {
        return this.objects.size();
    }

    public void setRowCount(int n) {
        if (this.objects.size() > n) {
            while (this.objects.size() > n) {
                this.objects.remove(this.objects.size() - 1);
            }
        } else {
            while (this.objects.size() < n) {
                this.objects.add(new Object());
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public Class getColumnClass(int n) {
        SingleObjectTableColumn singleObjectTableColumn = this.columns[n];
        return singleObjectTableColumn.getColumnClass();
    }

    public Object getSingleObjectAt(int n) {
        return this.objects.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        switch (n2) {
            case -1: {
                object = this.objects.get(n);
                break;
            }
            default: {
                SingleObjectTableColumn singleObjectTableColumn = this.columns[n2];
                object = singleObjectTableColumn.getAttribute(this.objects.get(n));
            }
        }
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n < this.objects.size()) {
            this.objects.set(n, object);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void addRow(Object object) {
        this.addRowObject(object);
        int n = this.objects.size() - 1;
        this.fireTableRowsInserted(n, n);
    }

    public void addRows(Object[] objectArray) {
        this.addRowObjects(objectArray);
        int n = this.objects.size();
        this.fireTableRowsInserted(n - objectArray.length, n - 1);
    }

    public void removeRow(int n) {
        this.removeRowIndex(n);
        this.fireTableRowsDeleted(n, n);
    }

    protected void addRowObject(Object object) {
        this.objects.add(object);
    }

    protected void addRowObject(Object object, int n) {
        this.objects.add(n, object);
    }

    protected int removeRowObject(Object object) {
        int n = this.objects.indexOf(object);
        this.objects.remove(n);
        return n;
    }

    protected void addRowObjects(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.objects.add(objectArray[i]);
        }
    }

    protected void removeRowIndex(int n) {
        this.objects.remove(n);
    }
}

