% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/au_stats.R
\name{au_stats}
\alias{au_stats}
\title{Extract Data from Athletes Unlimited Volleyball Website}
\usage{
au_stats(year = NULL, stored = TRUE)
}
\arguments{
\item{year}{A numeric value specifying the year for which to retrieve
statistics. Must be 2024 or later for LOVB or MLV and 2021 or later for AU.}

\item{stored}{A logical specifying whether to use stored data for previous years
(TRUE is default) or force the function to scrape the website (FALSE)}
}
\value{
A tibble containing team player season statistics.

Player data include:
year, rank, player, points, sets_played, kills, kills_per_set, attack_errors, attack_attempts, kill_percentage, assists, assists_per_set, setting_errors, service_aces, service_errors, service_aces_per_set, total_reception_attempts, reception_errors, positive_reception_percentage, digs, digs_per_set, blocks, blocks_per_set, block_assists, good_receptions
}
\description{
This function scrapes player season statistics for Athletes Unlimited Volleyball (AU)
players from the official AU website
\url{https://auprosports.com/volleyball/}.
}
\note{
This function requires:
\itemize{
\item The \if{html}{\out{<a href="https://ashbythorpe.github.io/selenider/">}}\if{html}{\out{<code>}}\{selenider\}\if{html}{\out{</code>}}\if{html}{\out{</a>}} R package
for web automation
\item \href{https://www.google.com/chrome/}{Google Chrome} browser installed on the system
\item An active internet connection
}

The function uses a headless Chrome browser session, so no browser window
will be visible during execution. Browser sessions are automatically closed
after data extraction.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Get 2025 player statistics
au_stats(year = 2025)
\dontshow{\}) # examplesIf}
}
\seealso{
Other statistics functions: 
\code{\link{get_stats}()},
\code{\link{group_stats}()},
\code{\link{lovb_stats}()},
\code{\link{mlv_stats}()}
}
\concept{statistics functions}
