% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pCure.R
\name{pCure.control}
\alias{pCure.control}
\title{Package options for pseudoCure}
\usage{
pCure.control(
  binit1 = NULL,
  binit2 = NULL,
  corstr = c("independence", "exchangeable", "ar1"),
  nlambda1 = 100,
  nlambda2 = 100,
  tol = 1e-07,
  maxit = 100
)
}
\arguments{
\item{binit1}{Initial value for the first component.
A zero vector will be used if not specified.}

\item{binit2}{Initial value for the second component
A zero vector will be used if not specified.}

\item{corstr}{A character string specifying the correlation structure.
The following are permitted: \code{"independence"}, \code{"exchangeable"},
and \code{"ar1"}.}

\item{nlambda1, nlambda2}{An integer value specifying the number of lambda.
This is only evoked when \code{lambda1 = "auto"} or \code{lambda2 = "auto"}.}

\item{tol}{A positive numerical value specifying the absolute error tolerance in GEE algorithms.}

\item{maxit}{An integer value specifying the maximum number of iteration.}
}
\value{
A list with control parameters.
}
\description{
This function provides the fitting options for the \code{pCure()} function.
}
\seealso{
\code{\link{pCure}}
}
