% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_mvrr.R
\name{correct_matrix_mvrr}
\alias{correct_matrix_mvrr}
\title{Multivariate select/correction for covariance matrices}
\usage{
correct_matrix_mvrr(
  Sigma_i,
  Sigma_xx_a,
  x_col,
  y_col = NULL,
  standardize = FALSE,
  var_names = NULL
)
}
\arguments{
\item{Sigma_i}{The complete range-restricted (unrestricted) covariance matrix to be corrected (selected upon).}

\item{Sigma_xx_a}{The matrix of unrestricted (range-restricted) covariances among of selection variables.}

\item{x_col}{The row/column indices of the variables in \code{Sigma_i} that correspond, in order, to the variables in \code{Sigma_xx_a}.}

\item{y_col}{Optional: The variables in \code{Sigma_i} not listed in \code{x_col} that are to be manipulated by the multivariate range-restriction formula.}

\item{standardize}{Should the function's output matrix be returned in standardized form (\code{TRUE}) or in unstandardized form (\code{FALSE}; the default).}

\item{var_names}{Optional vector of names for the variables in \code{Sigma_i}, in order of appearance in the matrix.}
}
\value{
A matrix that has been manipulated by the multivariate range-restriction formula.
}
\description{
Correct (or select upon) a covariance matrix using the Pearson-Aitken-Lawley multivariate selection theorem.
}
\examples{
Sigma_i <- reshape_vec2mat(cov = .2, var = .8, order = 4)
Sigma_xx_a <- reshape_vec2mat(cov = .5, order = 2)
correct_matrix_mvrr(Sigma_i = Sigma_i, Sigma_xx_a = Sigma_xx_a, x_col = 1:2, standardize = TRUE)
}
\references{
Aitken, A. C. (1934). Note on selection from a multivariate normal population.
\emph{Proceedings of the Edinburgh Mathematical Society (Series 2), 4}(2), 106–110.

Lawley, D. N. (1943). A note on Karl Pearson’s selection formulae.
\emph{Proceedings of the Royal Society of Edinburgh. Section A. Mathematical and Physical Sciences, 62}(1), 28–30.
}
