% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pte_aggte.R
\name{aggte_obj}
\alias{aggte_obj}
\title{Aggregated Treatment Effects Class}
\usage{
aggte_obj(
  overall.att = NULL,
  overall.se = NULL,
  type = "simple",
  egt = NULL,
  att.egt = NULL,
  se.egt = NULL,
  crit.val.egt = NULL,
  inf.function = NULL,
  min_e = NULL,
  max_e = NULL,
  balance_e = NULL,
  DIDparams = NULL
)
}
\arguments{
\item{overall.att}{The estimated overall ATT}

\item{overall.se}{Standard error for overall ATT}

\item{type}{The type of aggregation to be done.  Default is "overall".}

\item{egt}{Holds the length of exposure (for dynamic effects), the
group (for selective treatment timing), or the time period (for calendar
time effects)}

\item{att.egt}{The ATT specific to egt}

\item{se.egt}{The standard error specific to egt}

\item{crit.val.egt}{A critical value for computing uniform confidence
bands for dynamic effects, selective treatment timing, or time period
effects.}

\item{inf.function}{The influence function of the chosen aggregated parameters}

\item{min_e}{The minimum event time computed in the event study results.
This is useful when there are a huge number of pre-treatment periods.}

\item{max_e}{The maximum event time computed in the event study results.
This is useful when there are a huge number of post-treatment periods.}

\item{balance_e}{Drops groups that do not have at least \code{balance_e} periods
of post-treatment data.  This keeps the composition of groups constant
across different event times in an event study.
Default is NULL, in which case this is ignored.}

\item{DIDparams}{A DIDparams object}
}
\value{
an aggte_obj
}
\description{
Objects of this class hold results on aggregated
group-time average treatment effects.  This is derived from the AGGTEobj
class in the \code{did} package.

An object for holding aggregated treatment effect parameters.
}
