% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_functions.R
\name{two_by_two_subset}
\alias{two_by_two_subset}
\title{Two Period Two Group Subset}
\usage{
two_by_two_subset(
  data,
  g,
  tp,
  control_group = "notyettreated",
  anticipation = 0,
  base_period = "varying",
  ...
)
}
\arguments{
\item{data}{the full dataset}

\item{g}{the current group}

\item{tp}{the current time period}

\item{control_group}{whether to use "notyettreated" (default) or
"nevertreated"}

\item{anticipation}{the number of periods of anticipation (i.e., number
of periods before the treatment happens where the treatment can "already"
affect the outcome)}

\item{base_period}{The type of base period to use.  This only affects
the numeric value of results in pre-treatment periods.  Results in
post-treatment periods are not affected by this choice.  The default
is "varying", where the base period will "back up" to the immediately
preceding period in pre-treatment periods.  The other option is "universal"
where the base period is fixed in pre-treatment periods to be the period
right before the treatment starts.  "Universal" is commonly used in
difference-in-differences applications, but can be unnatural for other
identification strategies.}

\item{...}{extra arguments to get the subset correct}
}
\value{
list that contains the following elements:
\itemize{
\item \code{gt_data}: a \code{gt_data_frame} object that contains the
correct subset of data
\item \code{n1}: the number of observations in this subset
\item \code{disidx}: a vector of the correct ids for this subset
}
}
\description{
A function for computing a 2x2 subset of original data.
This is the subset with post treatment periods separately for the
treated group and comparison group and pre-treatment periods in the period
immediately before the treated group became treated.
}
