% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_features.R
\name{prep_hexgrid}
\alias{prep_hexgrid}
\title{Creates hexagon grid cells over study area}
\usage{
prep_hexgrid(outline, area, clip_level = 0, point_over = NULL, point_n = 0)
}
\arguments{
\item{outline}{SpatialPolygon or SpatialPolygonDataFrame that defines the area to draw hexgrid cells over}

\item{area}{scaler for the area of the grid cells in whatever units the outline is in}

\item{clip_level}{, you can clip grid cells if they are not entirely inside the outlined area, defaults to \code{0}
so any cells at least touching are included. Specify as proportion (so should not be greater than 1!)}

\item{point_over}{default \code{NULL}, but can pass in SpatialPoints and will only include grid cells that have at least one point}

\item{point_n}{default 0, only used if passing in \code{point_over}. Will return only grid cells with greater than \code{point_n} points}
}
\value{
A SpatialPolygonDataFrame object with columns
\itemize{
\item \code{id}, integer id value (not the same as row.names!)
\item \code{x}, x centroid of grid cell
\item \code{y}, y centroid of grid cell
\item \code{cover}, optional (only if clip_level > 0) proportion that grid cell is covered by \code{outline}
\item \code{count}, optional (only if you pass in \code{point_over}), total N of points over
}
}
\description{
Creates hexagon grid cells of given area over particular study area.
}
\details{
This generates a vector hex grid over the study area of interest. Hexgrids are sometimes preferred over square grid cells to
prevent aliasing like artifacts in maps (runs of particular values).
}
\examples{
\donttest{
library(sp) #for sp plot methods
#Base example, some barely touch
hnyc <- prep_hexgrid(nyc_bor,area=20000^2)
plot(hnyc)
plot(nyc_bor,border='red',add=TRUE)
#Example clipping hexagons that have dongle hexagons
hex_clip <- prep_hexgrid(nyc_bor,area=20000^2,clip_level=0.3)
plot(hex_clip,border='blue')
plot(nyc_bor,border='red',add=TRUE)
summary(hnyc)

#Example clipping hexagons with no overlap crimes
hnyc <- prep_hexgrid(nyc_bor,area=4000^2,point_over=nyc_shoot)
plot(hnyc)
plot(nyc_shoot,pch='.',add=TRUE)
}

}
\references{
Circo, G. M., & Wheeler, A. P. (2021). Trauma Center Drive Time Distances and Fatal Outcomes among Gunshot
Wound Victims. \emph{Applied Spatial Analysis and Policy}, 14(2), 379-393.
}
