% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImputeMissingVisits.R
\name{MarkMissing}
\alias{MarkMissing}
\title{Code Empty Visit Values as "Missing" as Appropriate}
\usage{
MarkMissing(timeline_df, windowWidth = 7, daysGrace = 0)
}
\arguments{
\item{timeline_df}{A data frame with columns \code{who}, \code{when},
\code{visit} and \code{randomized}. This data frame measures on which days
the subjects visited the clinic (\code{visit}) and indicates when the
subjects were randomized to Phase I of their respective studies (the
\code{randomized} column). This data set will contain one (and only one)
record per subject per day; and enough rows to cover all potential visits
per the protocol length of the study.}

\item{windowWidth}{How many days are expected between clinic visits? Defaults
to 7, representing weekly clinic visits.}

\item{daysGrace}{How many days late are subjects allowed to be for their
weekly visit. Defaults to 0. Under this default behavior with weekly
visits, a subject who visits the clinic on days 8 and 14 instead of days
7 and 14 will have a missing visit imputed for day 7.}
}
\value{
A copy of \code{timeline_df} with the column \code{visitYM} added.
This column is a copy of the \code{visit} column with additional cells
marking if a subject should have attended the clinic but did not.
}
\description{
Given a complete timeline of potential subject visits per study
protocol, mark certain visits as "Missing"
}
\details{
Most definitions of opioid use disorder treatment success or failure
partially depend on a tally of the number of missed clinic visits. For
example, a definition of early treatment failure could be "3 or more UDS
positive for non-study opioids or missing visits within the first 28 days
of randomization". Given a table of subject visits by day over the entire
protocol timeline, this function will estimate when each subject missed a
clinic visit (unfortunately, missed visits can often be improperly
recorded in the patient logs; if such information is complete, using this
function is unnecessary).

This estimation is conducted as follows: (1) first, for each subject, a
regular grid of days is spread from the randomization day to the end of
treatment by \code{windowWidth}; (2) next, we iterate over each day in
this regular grid, and at each step we check the next \code{windowWidth}
plus \code{daysGrace} days for a visit in that range, and we mark the day
at the end of the window as "missing" if there are no visits in that
range; (3) and finally, we combine these subject-specific data tables.
}
\examples{
   # TO DO
}
