% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_weeklyOpioidPattern.R
\docType{data}
\name{derived_weeklyOpioidPattern}
\alias{derived_weeklyOpioidPattern}
\title{Patient UDS Opioid Weekly Pattern Data}
\format{
A tibble with 3,560
rows and columns:
\describe{
\item{who}{Patient ID}
\item{startWeek}{The start of the "word" is how many weeks before
randomization? This should be -4 for most people, but can be as high
as -8. Note that week 0 is included, so a value of -4 represents data
in the 5th week before randomization; that is, 29-35 days prior to
randomization. Most subjects have timeline follow-back data 30 days
before consent, and delays between consent and randomization are
common.}
\item{randWeek1}{Week of first randomization (1, if randomized; NA if
not)}
\item{randWeek2}{Week of second randomization (only for CTN-0030)}
\item{endWeek}{The end of the "word" is how many weeks after
randomization? This depends on the study protocol, but should be
close to 16 or 24 weeks for most subjects.}
\item{Baseline}{A character string of symbols from \code{startWeek} to
the last week before \code{randWeek1}. Symbols are as defined in
\code{Phase_1}.
}
\item{Phase_1}{A character string of symbols from \code{randWeek1}
to \code{endWeek} (for subjects from CTN-0027 and CTN-0051) or the
last week before \code{randWeek2} (for CTN-0030). These symbols are:
\code{"+"} = the subject's UDS showed presence of an opioid in that
week; \code{"-"} = the subject's UDS showed absence of an opioid in
that week; \code{"*"} = two or more UDS in the same week, where >= 1
UDS was positive and >= 1 UDS was negative; \code{"o"} if the
subject was supposed to visit a clinic per the study protocol but did
not visit or did not complete a UDS screen; and \code{"_"} to
represent weeks wherein the subject was not scheduled to provide UDS.
}
\item{Phase_2}{A character string of symbols from \code{randWeek2}
to \code{endWeek} for subjects from CTN-0030 only. Symbols are as
defined in \code{Phase_1}.
}
}
}
\usage{
data(derived_weeklyOpioidPattern)
}
\description{
Show the pattern of positive, negative, and missing urine drug
screen (UDS) results for opioids by patient over the study protocol. Study
"Week 1" starts the day after randomization (for patients who were
randomized) or the day after signed consent (for patients who were not
randomized).
}
\details{
This data set contains a "word" describing weekly non-study opioid
use patterns as measured by UDS. Based on the substances screened in this
data set, our list of substances classified as an opioid is: Oxymorphone,
Opium, Fentanyl, Hydromorphone, Codeine, Suboxone, Tramadol, Morphine,
Buprenorphine, Hydrocodone, Opioid, Methadone, Oxycodone, and Heroin. UDS
results indicating the presence of one or more of these substances will be
marked with \code{"+"} for that week. UDS results negative for these
substances will be marked with \code{"-"}. If, by study protocol, the
subject was supposed to visit a clinic to complete a UDS but they did not,
then the visit for that week will be marked with \code{"o"}. If, by study
protocol, the subject was NOT supposed to visit a clinic to complete a UDS
for a given week, then visit for that week will be marked with \code{"_"}.
This data set is a derived data set; the script used to create it is
\code{"scripts/create_weeklyOpioidPattern_20211123.R"}.

NOTE: because our window is a strict weekly window, a subject could have
both positive and negative UDS within the same 7-day period. In this case,
the week is marked as \code{"*"}. Depending on the definition of treatment
failure or treatment success desired, these dual-status indicators can be
re-coded to \code{"+"} or \code{"-"} as appropriate. Also, some studies
include a baseline UDS in the week of consent (before the subject was
randomized to a treatment arm). Some subjects were randomized in the same
week as the week wherein consent was signed, while other subjects were
randomized weeks later. We represent the weeks before consent and the
variable number of weeks between consent and randomization with \code{"_"}
if there were no baseline UDS visits in those weeks (this represents the
pre-study period). For subjects who were never randomized, the weeks
before consent are also marked as pre-study (\code{"_"}), and all
subsequent protocol weeks are marked as missing.
}
\keyword{datasets}
