#' Studies on Practice Facilitation
#'
#' Results from 23 studies on the effect of practice facilitation in a
#'     primary care setting.
#'
#' @usage dat.baskerville2012
#'
#' @format The tibble contains the following columns:
#'     \tabular{lll}{
#'         \strong{author}    \tab \code{character} \tab first author of study \cr
#'         \strong{year}      \tab \code{numeric}   \tab publication year \cr
#'         \strong{design}    \tab \code{character} \tab study design (RCT, C-RCT, or CCT) \cr
#'         \strong{blinded}   \tab \code{boolean}   \tab if \code{TRUE}, the study was blinded \cr
#'         \strong{concealed} \tab \code{boolean}   \tab if \code{TRUE}, the study was concealed \cr
#'         \strong{yi}        \tab \code{numeric}   \tab observed mean difference in outcome (facilitated vs non-facilitated) \cr
#'         \strong{vi}        \tab \code{numeric}   \tab corresponding sampling variance
#'    }
#' @keywords datasets
#'
#' @source Baskerville, N. B., Liddy, C., & Hogg, W. (2012). Systematic review and meta-analysis of practice facilitation within primary care settings. The Annals of Family Medicine, 10(1), 63-74.
#'
"dat.baskerville2012"
