% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_example_filename.R
\name{get_example_filename}
\alias{get_example_filename}
\title{Get the full path to a PureseqTM example file.}
\usage{
get_example_filename(filename, folder_name = get_default_pureseqtm_folder())
}
\arguments{
\item{filename}{name of the example file, without the path}

\item{folder_name}{superfolder of PureseqTM.
The superfolder's name is \code{/home/[user_name]/.local/share}
by default, as can be obtained by
\link{get_default_pureseqtm_folder}}
}
\value{
the full path to a PureseqTM example file
}
\description{
Get the full path to a PureseqTM example file.
If the filename specified is not a PureseqTM example file,
this function will \link{stop}
}
\examples{
if (is_pureseqtm_installed()) {
  get_example_filename("1bhaA.fasta")
}
}
\seealso{
use \link{get_example_filenames} to get all PureseqTM
example filenames
}
\author{
Richèl J.C. Bilderbeek
}
