% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_topologies_from_sequences.R
\name{predict_topologies_from_sequences}
\alias{predict_topologies_from_sequences}
\title{Run PureseqTM directy on a protein sequence}
\usage{
predict_topologies_from_sequences(
  protein_sequences,
  folder_name = get_default_pureseqtm_folder(),
  temp_fasta_filename = tempfile(fileext = ".fasta")
)
}
\arguments{
\item{protein_sequences}{one ore more protein sequence,
each sequence with the amino acids as capitals, for
example \code{MEILCEDNTSLSSIPNSL}}

\item{folder_name}{superfolder of PureseqTM.
The superfolder's name is \code{/home/[user_name]/.local/share}
by default, as can be obtained by
\link{get_default_pureseqtm_folder}}

\item{temp_fasta_filename}{temporary FASTA filename,
which will deleted after usage}
}
\value{
a topology as a string of zeroes and ones, where a one denotes
that the corresponding amino acid is located within the membrane.
}
\description{
Run PureseqTM directy on a protein sequence
}
\examples{
if (is_pureseqtm_installed()) {
  protein_sequence <- paste0(
    "QEKNWSALLTAVVIILTIAGNILVIMAVSLEKKLQNATNYFLM",
    "SLAIADMLLGFLVMPVSMLTILYGYRWP"
  )
  predict_topology_from_sequence(protein_sequence)
}
}
\seealso{
use \link{mock_predict_topologies_from_sequences}
to mock the prediction of protein sequences, as can be useful
in testing
}
\author{
Richèl J.C. Bilderbeek
}
