% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/put_diagram.R
\name{put_diagram}
\alias{put_diagram}
\title{Create Mermaid Diagram from PUT Workflow}
\usage{
put_diagram(
  workflow,
  output = "console",
  file = "workflow_diagram.md",
  title = NULL,
  direction = "TD",
  node_labels = "label",
  show_files = FALSE,
  show_artifacts = FALSE,
  show_workflow_boundaries = TRUE,
  style_nodes = TRUE,
  theme = "light"
)
}
\arguments{
\item{workflow}{Data frame returned by \code{\link{put}()} containing workflow nodes}

\item{output}{Character string specifying output format. Options:
\itemize{
\item "console" - Print to console (default)
\item "file" - Save to file specified by \code{file} parameter
\item "clipboard" - Copy to clipboard (if available)
\item "raw" - Return raw mermaid code without markdown fences (for knitr/pkgdown)
}}

\item{file}{Character string specifying output file path (used when output = "file")}

\item{title}{Character string for diagram title (optional)}

\item{direction}{Character string specifying diagram direction. Options:
"TD" (top-down), "LR" (left-right), "BT" (bottom-top), "RL" (right-left)}

\item{node_labels}{Character string specifying what to show in nodes:
"name" (node IDs), "label" (descriptions), "both" (ID: label)}

\item{show_files}{Logical indicating whether to show file connections}

\item{show_artifacts}{Logical indicating whether to show data files as nodes.
When TRUE, creates nodes for all input/output files, not just script connections.
This provides a complete view of the data flow including terminal outputs.}

\item{show_workflow_boundaries}{Logical indicating whether to apply special styling
to nodes with node_type "start" and "end". When TRUE, these nodes get distinctive
workflow boundary styling (icons, colors). When FALSE, they render as regular nodes.}

\item{style_nodes}{Logical indicating whether to apply styling based on node_type}

\item{theme}{Character string specifying color theme. Options:
"light" (default), "dark", "auto" (GitHub adaptive), "minimal", "github"}
}
\value{
Character string containing the mermaid diagram code
}
\description{
Generates a Mermaid flowchart diagram from putior workflow data, showing
the flow of data through your analysis pipeline.
}
\examples{
\dontrun{
# Basic usage - shows only script connections
workflow <- put("./src/")
put_diagram(workflow)

# Show all data artifacts as nodes (complete data flow)
put_diagram(workflow, show_artifacts = TRUE)

# Show artifacts with file labels on connections
put_diagram(workflow, show_artifacts = TRUE, show_files = TRUE)

# Show workflow boundaries with special start/end styling
put_diagram(workflow, show_workflow_boundaries = TRUE)

# Disable workflow boundaries (start/end nodes render as regular)
put_diagram(workflow, show_workflow_boundaries = FALSE)

# GitHub-optimized theme for README files
put_diagram(workflow, theme = "github")

# Save to file with artifacts enabled
put_diagram(workflow, show_artifacts = TRUE, output = "file", file = "workflow.md")

# For use in knitr/pkgdown - returns raw mermaid code
# Use within a code chunk with results='asis'
cat("```mermaid\n", put_diagram(workflow, output = "raw"), "\n```\n")
}
}
