% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/puzzle.R
\name{puzzle}
\alias{puzzle}
\title{puzzle}
\usage{
puzzle(directory = NULL, order, coercion = list(name = NULL, sep =
  ","), optionalcolumns = NULL, pk = list(name = NULL, data = NULL),
  dose = list(name = NULL, data = NULL), cov = list(name = NULL, data =
  NULL), pd = list(name = NULL, data = NULL), extratimes = list(name =
  NULL, data = NULL), nm = list(name = NULL), fillcolumns = NULL,
  nocoercioncolumns = NULL, norepeatcolumns = NULL, initialindex = 0,
  na.strings = "N/A", arrange = "ID,TIME,CMT,desc(EVID)",
  datetimeformat = "\%Y-\%m-\%d \%H:\%M:\%S", timeunits = "hours",
  timezone = Sys.timezone(), ignore = "C", missingvalues = ".",
  parallel = TRUE, verbose = FALSE, username = NULL)
}
\arguments{
\item{directory}{path to your directory}

\item{order}{define the absorption order, can be 0, 1, c(0,1), or c(1,1)}

\item{coercion}{define name for coercion file}

\item{optionalcolumns}{define optional columns}

\item{pk}{define the required file containing the pk information. It can be a .csv or an .xlsx file}

\item{dose}{define the required file containing the dose information. It can be a .csv, an .xlsx file or an R object.}

\item{cov}{define the optional file containing the covariate information. It can be a .csv, an .xlsx file or an R object.}

\item{pd}{define the optional file containing the pd information. It can be a .csv, or a .xlsx file.}

\item{extratimes}{define the optional file containing the additional times. It can be a .csv, or a .xlsx file.}

\item{nm}{name of output file generated by puzzle}

\item{fillcolumns}{define columns to be filled}

\item{nocoercioncolumns}{define columns to be dropped from the coercion file}

\item{norepeatcolumns}{define columns not to be repeated}

\item{initialindex}{define the lower category of categorical covariates}

\item{na.strings}{define value for na}

\item{arrange}{define how the columns should be arranged}

\item{datetimeformat}{define format for date times}

\item{timeunits}{define time units if needed}

\item{timezone}{define timezone}

\item{ignore}{define ignore value}

\item{missingvalues}{define missing value}

\item{parallel}{define parallel zero + first order absorption}

\item{verbose}{define verbose}

\item{username}{define person performing the assembling}
}
\value{
a pharmacometrics ready data set
}
\description{
Build pharmacometric data sets from basic tabulated files
}
\examples{
\dontrun{
nm = list(pk = list(parent=as.data.frame(puzzle::df_pk_start)),
          dose=as.data.frame(puzzle::df_dose_start), 
          cov=as.data.frame(puzzle::df_cov_start))
puzzle(directory=file.path(tempdir()), 
       order=c(0), 
       pk=list(data=nm$pk), 
       dose=list(data=nm$dose), 
       cov=list(data=nm$cov))
}
}
