% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RWDInterval.R
\name{RWDInterval}
\alias{RWDInterval}
\title{Mean relative water deficit (RWD) of an interval}
\usage{
RWDInterval(data, sample = "sample", fresh.weight = "fitted.fw",
  dry.weight = "dry.weight",
  fresh.weight.saturated = "fresh.weight.saturated")
}
\arguments{
\item{data}{data frame with columns of equal length containing at least columns with the fresh weight (g),
the dry weight (g) and the saturated fresh weight (g), ordered by sample by descending by fresh weight. A column containing
the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional name of the column in data containing the sample IDs, default: "sample"}

\item{fresh.weight}{optional name of the column in data containing
the numeric fresh weight values (g); default: "fitted.fw"}

\item{dry.weight}{optional name of the column in data containing
the numeric dry weight values (g); default: "dry.weight"}

\item{fresh.weight.saturated}{optional name of the column in data containing
the numeric saturated fresh weight values (g); default: "fresh.weight.saturated"}
}
\value{
the original data frame extended by a numeric column with the mean relative water deficit for the measurement
interal (RWD.interval) (\%).
}
\description{
Calculates relative water deficit (\%) as mean value of a measurement interval
}
\details{
First, the mean fresh weight is calculated for each measurement interval. Relative water deficit (\%) is
then calculated as:
\deqn{RWD = 100 - 100 * ((mFW - DW) (FWs - DW)^-1)}
whereas mFW = mean fresh weight, DW = dry weight and FWs = fresh weight at water saturation.
}
\examples{
# get example data
df <- leaf_drying_data

# extend df by RWD
df_with_RWD <- RWDInterval(df, fresh.weight = "fresh.weight")

}
