% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AB_t2n_prop.R
\name{AB_t2n_prop}
\alias{AB_t2n_prop}
\title{Two-Sample t-Test Power Analysis for Proportions}
\usage{
AB_t2n_prop(prop_A = NULL, prop_B = NULL, N = NULL, percent_B = NULL,
  sig_level = NULL, power = NULL, alternative = c("two_sided", "less",
  "greater"), max_sample = 1e+07)
}
\arguments{
\item{prop_A}{Proportion of successes in group A (between 0 and 1)}

\item{prop_B}{Proportion of successes in group B (between 0 and 1)}

\item{N}{Total number of observations (sum of observations for groups A and B)}

\item{percent_B}{Percentage of total observations allocated to group B
(between 0 and 1 - e.g. input .5 for 50\%)}

\item{sig_level}{Significance level (Type I error probability)}

\item{power}{Power of test (1 minus Type II error probability)}

\item{alternative}{Character string specifying the alternative hypothesis,
must be one of "two_sided" (default), "greater" or "less"}

\item{max_sample}{Maximum sample size that is searched for}
}
\value{
Object of class "power.htest", a list of the arguments
(including the computed one).
}
\description{
\code{AB_t2n_prop} performs the power analysis for AB testing, and when
    dependent variables are proportions (between 0 and 1). It uses the Welch's t-test,
    which allows for the standard deviation to vary across groups.
}
\details{
Exactly one of the parameters 'prop_A', 'prop_B', 'N', 'percent_B', 'sig_level',
    and 'power' must be passed as NULL, and the omitted parameter is determined
    from the others. The standard deviations for each group are calculated using the
    formula sqrt(prop * (1 - prop)).
    When 'percent_B' is the parameter omitted,
    two solutions may exist, in which case the smaller value will be returned.
    For two_sided tests, when 'prop_A' or 'prop_B' is omitted, two solutions may exist,
    in which case both will be reported
}
\examples{
# Search for power given other parameters
AB_t2n_prop(prop_A = .2, prop_B = .25,
           N = 3000, percent_B = .3,
           sig_level = .05, alternative = 'two_sided')

# Search for proportion in group B required to satisfy other parameters
AB_t2n_prop(prop_A = .2, N = 3000, percent_B = .3,
power = .8, sig_level = .05,
alternative = 'two_sided')

}
