% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_analysis_tools.R
\name{p_significance}
\alias{p_significance}
\title{Probability of Practical Significance (Enhanced bayestestR-style)}
\usage{
p_significance(
  object,
  parameters = NULL,
  threshold = "default",
  nsim = 1000,
  verbose = TRUE
)
}
\arguments{
\item{object}{A \code{qbrms_fit} object.}

\item{parameters}{Optional character vector of parameter names; if \code{NULL},
all fixed-effect coefficients are used.}

\item{threshold}{The threshold value that separates significant from negligible effect:
\itemize{
\item \code{"default"}: Uses 0.1 as threshold range around zero
\item A single numeric value (e.g., 0.1): Creates symmetric range around zero (-0.1, 0.1)
\item A numeric vector of length two (e.g., c(-0.2, 0.1)): Asymmetric threshold
\item A list of numeric vectors: Each vector corresponds to a parameter
\item A named list: Names correspond to parameter names
}}

\item{nsim}{Number of draws to simulate for the approximation.}

\item{verbose}{Logical; print progress information.}
}
\value{
A data frame of class \code{qbrms_p_significance} with columns
\code{Parameter}, \code{ps}, \code{Median}, \code{CI_low}, \code{CI_high},
\code{Threshold_low}, \code{Threshold_high}, and \code{Interpretation}.
}
\description{
Compute the probability that each parameter is above a threshold
in the median's direction, similar to bayestestR::p_significance().
This represents the proportion of the posterior distribution that
indicates a "significant" effect in the median's direction.
}
