% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_case_fixes.R
\name{validate_model_data}
\alias{validate_model_data}
\title{Validate data before model fitting}
\usage{
validate_model_data(formula, data, family, verbose = TRUE)
}
\arguments{
\item{formula}{A model formula.}

\item{data}{A \code{data.frame} containing the variables in the model.}

\item{family}{A family object such as \code{gaussian()}, \code{binomial()},
or \code{poisson()}. Used for basic, family-specific checks.}

\item{verbose}{Logical; print a summary of issues found.}
}
\value{
A list with elements \code{valid} (logical), \code{errors}
(character vector), \code{warnings} (character vector), and
\code{n_complete} (integer count of complete cases across the variables
in the model).
}
\description{
Perform lightweight diagnostics on the response and predictors to catch
common issues that derail model fitting (missingness, zero variance,
impossible values for specific families, simple multicollinearity flags,
and sample-size sanity checks).
}
\keyword{internal}
