% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.2.R
\name{qser2sar}
\alias{qser2sar}
\title{Spline Autoregression (SAR) Model of Quantile Series}
\usage{
qser2sar(
  y.qser,
  tau0,
  tau = tau0,
  p = NULL,
  order.max = NULL,
  spar = NULL,
  method = c("GCV", "AIC", "BIC"),
  weights = rep(1, length(tau0)),
  interval = c(-1.5, 1.5)
)
}
\arguments{
\item{y.qser}{matrix or array of pre-calculated QSER at \code{tau0} using, e.g., \code{qser()}}

\item{tau0}{quantile levels used to compute \code{y.qser}}

\item{tau}{quantile levels for evaluation (\code{min(tau0)} <= \code{tau} <= \code{max(tau0)}; 
default = \code{tau0})}

\item{p}{order of SAR model (default = \code{NULL}: automatically selected by AIC)}

\item{order.max}{maximum order for AIC if \code{p = NULL} (default = \code{NULL}: determined by \code{stats::ar()})}

\item{spar}{penalty parameter alla \code{stats::smooth.spline()} (default = \code{NULL}: automatically selected)}

\item{method}{criterion for penalty parameter selection: \code{"GCV"} (default), \code{"AIC"}, or \code{"BIC"}}

\item{weights}{sequence of weights (default = \code{rep(1,length(tau0))})}

\item{interval}{interval for \code{spar} optimization (default = \code{c(-1.5,1.5)})}
}
\value{
a list with the following elements:
  \item{A}{matrix or array of SAR coefficients}
  \item{V}{vector or matrix of SAR residual covariance}
  \item{p}{order of SAR model}
  \item{spar}{penalty parameter}
  \item{n}{length of time series}
  \item{tau}{quantile levels for evaluation}
  \item{tau0}{quantile levels for fitting}
  \item{weights}{weights in penalty function}
  \item{fit}{object containing details of SAR fit}
}
\description{
This function fits spline autoregression (SAR) model to quantile series (QSER).
}
