% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_fa.R
\name{prep_fa}
\alias{prep_fa}
\title{Prepare fatty acid information analysis}
\usage{
prep_fa(df_fa)
}
\arguments{
\item{df_fa}{A data frame containing fatty acid names, calibration
coefficients, and 0/1 definitions of fatty acid suites.  \code{qfasar} has
strict formatting requirements for \code{df_fa}; please see Details and/or
the vignette.}
}
\value{
A list containing the following elements: \describe{
  \item{cc}{A numeric vector of calibration coefficients.}
  \item{use}{A logical vector defining a fatty acid suite.}
  \item{fa_names}{A character vector of fatty acid names.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
  }
}
\description{
The function \code{prep_fa} processes the information in a fatty acid
suites data frame and prepares that information for application to fatty
acid signatures.
}
\section{Details}{

This function is designed to be called by the user after the fatty acid data
frame has been read.  The data frame should contain a complete list of all
fatty acids in the prey and predator signature data, one or more sets of
calibration coefficients with an indicator of which set to use, one or more
fatty acid suite definitions with an indicator of which suite to use, and
optional comments.  Please refer to the vignette for additional information.

The fatty acid data frame must strictly meet the following formatting
requirements.
  \itemize{
  \item The first row must contain a header for each column.
  \item The second row must list "use_me" in the first column, a 1 in the
    column for the set of calibration coefficients to be used, a 1 in the
    column for the fatty acid suite to be used, and a 0 in all other columns.
  \item Starting with row three, the first column must contain fatty acid
    names, which must exactly match the corresponding components of the
    headers in any prey and predator signature data frames.
  \item Starting with row three, Columns 2 to k must contain calibration
    coefficients for each fatty acid.  Multiple sets of calibration
    coefficients can be in the data frame.  The set to be used must contain
    a 1 in Row 1 and the others must contain a 0 in Row 1.
  \item Columns k+1 to m must contain one or more definitions of fatty acid
    suites. Membership in a suite is defined by 0/1 indicators, with a 1
    indicating membership.  Definitions for multiple suites can be in the
    data frame.  For example, two columns could contain indicators defining
    membership in the dietary and extended-dietary suites of fatty acids
    (Iverson et al. 2004).  The suite to be used must contain a 1 in Row 1
    and the others must contain a 0 in Row 1.
  \item An optional last column can contain comments.
  \item Please see the vignette for examples of how to format this data
  frame.
}
}

\section{References}{

Iverson, S.J., C. Field, W.D. Bowen, and W. Blanchard. 2004.
  Quantitative fatty acid signature analysis: A new method of
  estimating predator diets. \emph{Ecological Monographs} 74:211-235.
}

\examples{
prep_fa(data.frame(fa = c("use_me", "fa_1", "fa_2", "fa_3"),
                   cc = c(1, 0.75, 1.25, 1.0),
                   use = c(1, 1, 1, 1)))

prep_fa(data.frame(fa = c("use_me", "fa_1", "fa_2", "fa_3"),
                   cc1 = c(0, 0.75, 1.25, 1.00),
                   cc2 = c(1, 1.2, 0.8, 0.9),
                   use_1 = c(0, 1, 1, 0),
                   use_2 = c(1, 1, 1, 0)))

}
