library(multcomp)

################################################################################
##################################   DATA   ####################################
################################################################################

# Example from Hothorn et al. (2020)
daphnia =
	structure(list('Concentration' = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.56, 1.56, 1.56, 1.56, 1.56, 1.56, 1.56, 1.56,
									   1.56, 1.56, 3.12, 3.12, 3.12, 3.12, 3.12, 3.12, 3.12, 3.12, 3.12, 3.12, 6.25,
									   6.25, 6.25, 6.25, 6.25, 6.25, 6.25, 6.25, 6.25, 6.25, 12.5, 12.5, 12.5, 12.5,
									   12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25),
				   Adults = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9,
				   		   10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9,10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
				   Number_Young = c(27, 30, 29, 31, 16, 15, 18, 17, 14, 27, 32, 35, 32, 26, 18, 29, 27, 16, 35, 13, 39, 30,
				   				 33, 33, 36, 33, 33, 27, 38, 44, 27, 34, 36, 34, 31, 27, 33, 21, 33, 31, 10, 13, 7, 7, 7,
				   				 10, 10, 16, 12, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),
			  class = "data.frame", row.names = c(NA, 60L))

daphnia$Conc = as.factor(daphnia$Concentration)

contingency.table <- matrix(c(20, 10, 40, 10, 90, 15), nrow=2, ncol=3)
rownames(contingency.table)=c("Success", "Failure")
colnames(contingency.table)=c("Control", "T1", "T2")
contingency.table


################################################################################
##################################   CPCAT   ###################################
################################################################################

# testing CPCAT
res = CPCAT(groups=daphnia$Conc,
			counts=daphnia$Number_Young,
			control.name = NULL,
			bootstrap.runs = 10000,
			use.fixed.random.seed = 123,
			get.contrasts.and.p.values = F,
			show.output = T)

################################################################################
###############################   DUNNETT GLM   ################################
################################################################################

# test Dunnett GLM
res = Dunnett.GLM(groups=daphnia$Conc,
				  counts=daphnia$Number_Young,
				  control.name = NULL,
				  zero.treatment.action = "identity.link")

res = Dunnett.GLM(groups=daphnia$Conc,
				  counts=daphnia$Number_Young,
				  control.name = NULL,
				  zero.treatment.action = "log(x+1)")

################################################################################
##################################   CPFISH   ##################################
################################################################################


CPFISH(contingency.table = contingency.table, control.name = NULL, simulate.p.value = T, use.fixed.random.seed = 123)


################################################################################
#################################   Test bMDD   ################################
################################################################################

###############################   CPCAT tests   ################################
# Idea: shift lambda of Poisson distribution until there is a certain proportion of significant results
CPCAT.bMDD(groups = daphnia$Conc,
		   counts = daphnia$Number_Young,
		   control.name = NULL,
		   alpha = 0.05,
		   shift.step = -1,
		   bootstrap.runs = 5,
		   power = 0.8,
		   max.iterations = 1000,
		   use.fixed.random.seed = 123,
		   CPCAT.bootstrap.runs = 10,
		   show.progress = T,
		   show.results = T)

############################   GLM.Dunnett tests   #############################

res = Dunnett.GLM.bMDD(groups = daphnia$Conc,
					   counts = daphnia$Number_Young,
					   control.name = NULL,
					   alpha = 0.05,
					   shift.step = -1,
					   bootstrap.runs = 5,
					   power = 0.8,
					   max.iterations = 1000,
					   use.fixed.random.seed = 123,
					   Dunnett.GLM.zero.treatment.action = "log(x+1)",
					   show.progress = T,
					   show.results = T)

##############################   CPFISH tests   ################################

CPFISH.bMDD(contingency.table = contingency.table, # contingency.table is a matrix with observed data (e.g. survival counts)
			control.name = NULL,		# character string with control group name
			alpha = 0.05,				# significance level
			shift.step = -0.1,		# step of shift (negative as a reduction is assumed)
			bootstrap.runs = 10,		# number of bootstrap runs (draw Poisson data n times)
			power = 0.8,			# proportion of bootstrap.runs that return significant differences
			max.iterations = 1000,		# max number of iterations to not get stuck in the while loop
			simulate.p.value = TRUE,	# use simulated p-values or not
			use.fixed.random.seed = 123,# fix seed, e.g. 123, for random numbers if desired (enables to reproduce results)
			show.progress = T,			# show progress for each shift of lambda
			show.results = T) 			# show results


################################################################################
################################   Test power   ################################
################################################################################

###############################   CPCAT tests   ################################
# Idea: shift lambda of Poisson distribution until there is a certain proportion of significant results
CPCAT.power(groups = daphnia$Conc,
			counts = daphnia$Number_Young,
			control.name = NULL,
			alpha = 0.05,
			bootstrap.runs = 10,
			use.fixed.random.seed = 123,
			CPCAT.bootstrap.runs = 10,
			show.progress = T,
			show.results = T)


############################   GLM.Dunnett tests   #############################

res = Dunnett.GLM.power(groups = daphnia$Conc,
						counts = daphnia$Number_Young,
						control.name = NULL,
						alpha = 0.05,
						bootstrap.runs = 10,
						use.fixed.random.seed = 123,
						Dunnett.GLM.zero.treatment.action = "log(x+1)",
						show.progress = T,
						show.results = T)

##############################   CPFISH tests   ################################

CPFISH.power(contingency.table = contingency.table, # contingency.table is a matrix with observed data (e.g. survival counts)
			 control.name = NULL,		# character string with control group name
			 alpha = 0.05,				# significance level
			 bootstrap.runs = 10,		# number of bootstrap runs (draw Poisson data n times)
			 simulate.p.value = TRUE,	# use simulated p-values or not
			 use.fixed.random.seed = 123,# fix seed, e.g. 123, for random numbers if desired (enables to reproduce results)
			 show.progress = T,			# show progress for each shift of lambda
			 show.results = T) 			# show results
