% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperrectangle_slice.R
\name{slice_hyperrect}
\alias{slice_hyperrect}
\title{Multivariate Slice Sampler with Shrinking Hyperrectangle}
\usage{
slice_hyperrect(x, log_target, w = NULL, L = NULL, R = NULL)
}
\arguments{
\item{x}{The current state (as a numeric vector).}

\item{log_target}{A function taking numeric vector that evaluates the log-target
density, returning a numeric scalar.}

\item{w}{A numeric vector tuning the algorithm which gives the typical slice
width in each dimension. This is a main tuning parameter of the algorithm.
If \code{NULL}, the sampler begins shrinking from the supplied boundaries (should,
correspond with the support).}

\item{L}{Numeric vector giving the lower boundary of support in each dimension.}

\item{R}{Numeric vector giving the upper boundary of support in each dimension.
Will be used if \code{w} is null. If all of \code{L}, \code{R}, and \code{w}
are null, then the boundaries default to those of the unit hypercube.}
}
\value{
A list contains two elements: "x" is the new state and "nEvaluations"
is the number of evaluations of the target function used to obtain the new
state.
}
\description{
Multivariate slice sampler
in Algorithm 8 of Neal (2003) using the "shrinkage" procedure.
}
\examples{
lf <- function(x) dbeta(x[1], 3, 4, log = TRUE) + dbeta(x[2], 5, 3, log = TRUE)
n_iter <- 10 # set to 1e4 for more complete illustration
draws <- matrix(0.2, nrow = n_iter, ncol = 2)
nEvaluations <- 0L
for (i in seq.int(2, n_iter)) {
 out <- slice_hyperrect(draws[i - 1, ], log_target = lf, w = c(0.5, 0.5))
 draws[i,] <- out$x
 nEvaluations <- nEvaluations + out$nEvaluations
 cat(i, '\r')
}
nEvaluations / (nrow(draws) - 1)
plot(draws[,1], draws[,2], xlim = c(0, 1))
hist(draws[,1], freq = FALSE); curve(dbeta(x, 3, 4), col = "blue", add = TRUE)
hist(draws[,2], freq = FALSE); curve(dbeta(x, 5, 3), col = "blue", add = TRUE)

}
\references{
Neal, R. M. (2003), "Slice sampling," \emph{The Annals of Statistics}, 31, 705-767. \doi{https://doi.org/10.1214/aos/1056562461}
}
