% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangmesh.R
\name{triangmesh}
\alias{triangmesh}
\alias{dtriangmesh}
\alias{triangmesh.matrix}
\alias{triangmesh.BasicRaster}
\alias{dtriangmesh.default}
\title{Create a triangle-type mesh for use in rgl.}
\usage{
triangmesh(
  x,
  z = x,
  na.rm = FALSE,
  ...,
  texture = NULL,
  texture_filename = NULL
)

\method{triangmesh}{matrix}(
  x,
  z = x,
  na.rm = FALSE,
  ...,
  texture = NULL,
  texture_filename = NULL
)

\method{triangmesh}{BasicRaster}(
  x,
  z = x,
  na.rm = FALSE,
  ...,
  texture = NULL,
  texture_filename = NULL
)

dtriangmesh(
  x,
  z = x,
  na.rm = FALSE,
  ...,
  texture = NULL,
  texture_filename = NULL
)

\method{dtriangmesh}{default}(
  x,
  z = x,
  na.rm = FALSE,
  ...,
  texture = NULL,
  texture_filename = NULL
)
}
\arguments{
\item{x}{raster object for mesh structure}

\item{z}{raster object for height values}

\item{na.rm}{remove quads where missing values?}

\item{...}{ignored}

\item{texture}{optional input RGB raster, 3-layers}

\item{texture_filename}{optional input file path for PNG texture}
}
\value{
mesh3d (primitivetype triangle)
}
\description{
Convert an object to a \code{mesh3d} (of rgl package) triangle mesh,
with methods for \code{\link[raster:raster]{raster::raster()}} and \code{matrix}.
}
\details{
\code{triangmesh()} generates the point-based interpretation of a raster (POINT) with the obvious continuous
interpretation. \code{dtriangmesh} splits the mesh so that each primitive is independent.  This is more coherent
than the analogous distinction for quadmesh, though both will appear the same on creation.

The output is described as a mesh because it is a dense representation
of a continuous shape, in this case plane-filling triangles defined
by index of three of the available vertices.

The \code{z} argument defaults to the input \code{x} argument, though may be set to \code{NULL}, a constant
numeric value, or another raster. If the coordinate system of \code{z} and \code{x} don't match the z values
are queried by reprojection.

Any raster RGB object (3-layers, ranging in 0-255) may be used as
a \emph{texture} on the resulting mesh3d object.
It is not possible to provide rgl with an object of data for texture, it must be a PNG file and so
the in-memory \code{texture} argument is written out to PNG file (with a message). The location of the file
may be set explicitly with \code{texture_filename}.  Currently it's not possible to not use the \code{texture} object
in-memory.
}
\examples{
library(raster)
r <- setExtent(raster(volcano), extent(0, nrow(volcano), 0, ncol(volcano)))
tm <- triangmesh(r)

## jitter the mesh just enough to show that they are distinct in the discrete case
a <- dtriangmesh(r)
a$vb[3L, ] <- jitter(a$vb[3L, ], factor = 10)
}
