% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cqs.R
\name{cqs}
\alias{cqs}
\title{Central quantile subspace}
\usage{
cqs(x, y, tau = 0.5, dtau = NULL)
}
\arguments{
\item{x}{A design matrix (n x p).  The rows represent observations and the
columns represent predictor variables.}

\item{y}{A vector of the response variable.}

\item{tau}{A quantile level, a number strictly between 0 and 1.}

\item{dtau}{An optional dimension of the central quantile subspace.  If
specified, it should be an integer between 1 and p, the number of columns
of the design matrix \code{x}.  In the context of the algorithm, if
\code{dtau} is known to be one, i.e., the assumed model is a single-index
model, then the algorithm stops after estimating the initial vector and
saves computational time.  However, if \code{dtau} is greater than one or
(more realistically) unknown, then the algorithm continues on creating more
vectors.}
}
\value{
\code{cqs} computes the directions of the central quantile subspace
and returns:
\item{qvectors: }{The estimated directions of the
\eqn{\tau}th central quantile subspace.}

\item{qvalues: }{The eigenvalues resulting from the eigenvalue decomposition
of the matrix with column vectors that span the central quantile subspace.
If \code{dtau} is one, the \code{qvalues} output is not produced.}

\item{dtau: }{Suggested dimension of the central quantile subspace.  If
\code{dtau} is specified by the user then the algorithm outputs the
user-defined value.  If \code{dtau} is not specified by the user then the
algorithm outputs a suggested dimension using the modified-BIC type
criterion of Zhu et al. (2010).  Note that this is one suggested method to
estimate the structural dimension and is not necessarily a perfect one. The
user has the option to use the eigenvalues \code{qvalues} on other
criteria, like cross-validation, and determine the estimated dimension of
the subspace.}
}
\description{
\code{cqs} estimates the directions of the central quantile subspace.
}
\details{
The function computes the directions that span the \eqn{\tau}th central
quantile subspace, i.e., the directions that define linear combinations of
the predictor \code{x} that contain all the information available on the
conditional quantile function.

The function starts by estimating the initial vector, which is defined as the
least-squares estimator from regressing the conditional quantile on the
predictor variable \code{x}. Then, if the dimension of the central quantile
subspace is one, the algorithm stops and reports that vector as the basis of
the central quantile subspace. Otherwise, the algorithm continues by creating
more vectors and applying an eigenvalue decomposition to extract linearly
independent vectors.
}
\examples{
# estimate the directions of a single-index model
set.seed(1234)
n <- 100
p <- 10
x <- matrix(rnorm(n * p), n, p)
error <- rnorm(n)
y <- 3 * x[, 1] + x[, 2] + error
tau <- 0.5
out <- cqs(x, y, tau, dtau = 1)
out
# without specifying dtau
out <- cqs(x, y, tau)
out
out$qvectors[, 1:out$dtau]

}
\references{
Zhu, L.-P., Zhu, L.-X., Feng, Z.-H. (2010) Dimension reduction in
regression through cumulative slicing estimation. \emph{Journal of the
American Statistical Association}, 105, 1455-1466.
}
