% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_quant_est.R
\name{dr_quant_est}
\alias{dr_quant_est}
\title{The Doubly Robust Quantile Estimator for a Given Treatment Regime}
\usage{
dr_quant_est(beta, x, y, a, prob, tau, y.a.0, y.a.1, num_min = FALSE)
}
\arguments{
\item{beta}{a vector indexing the treatment regime.
It indexes a linear treatment regime:  
\deqn{ d(x)= I\{\beta_0 + \beta_1 x_1 + ... + \beta_k x_k > 0\}.
}{ d(x)= I{\beta_0 + \beta_1*x_1 + ... + \beta_k*x_k > 0}.}}

\item{x}{a matrix of observed covariates from the sample. 
Notice that we assumed the class of treatment regimes is linear.
This is important that columns in \code{x} matches with \code{beta}.}

\item{y}{a vector, the observed responses from a sample}

\item{a}{a vector of 0s and 1s, the observed treatments from a sample}

\item{prob}{a vector, the propensity scores of getting treatment 1 in the samples}

\item{tau}{The quantile of interest}

\item{y.a.0}{Estimated conditional potential outcome given that treatment = 0,
which can be calculated by the function \code{augX}.}

\item{y.a.1}{Estimated conditional potential outcome given that treatment = 1,
which can be calculated by the function \code{augX}.}

\item{num_min}{logical. If \code{TRUE}, the number of global minimizers for the 
objective function is returned.}
}
\description{
Given a fixed treatment regime, this doubly robust estimator
estimates the marginal quantile of responses when it is followed by
every unit in the target population. It took advantages of conditional
quantile functions for different treatment levels when they are available.
}
\details{
The double robustness property means that it can consistently estimate
the marginal quantile when either the propensity score model is correctly
specified, or the conditional quantile function is correctly specified.
}
\seealso{
\code{\link{augX}}
}
