% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changesAA.R
\name{changesAA}
\alias{changesAA}
\title{Identification of diagnostic molecular characters in a nucleotide alignment
that also cause diagnostic characters in the corresponding amino acid
alignment}
\usage{
changesAA(DNAbin, taxVector = dimnames(DNAbin)[[1]], codonstart = 1,
  taxOfInt = "all", types = c("type1", "type2", "type3"))
}
\arguments{
\item{DNAbin}{An object (the nucleotide alignment) of class 'DNAbin'.}

\item{taxVector}{The taxon vector. Default assumes that each row in the
alignment belongs to a different taxon.}

\item{codonstart}{An integer defining where to start the translation of the
nucleotide alignment into the corresp. amino acid alignment. Default is 1.}

\item{taxOfInt}{A vector containing the taxa for which the above mentioned
characters shall be extracted. Default is "all".}

\item{types}{A vector containing the types of diagnostic characters
(in the nucleotide alignment) that shall be considered. The types
can be "all" or any combination of "type1", "type2", "type3" and "type4".
Default is "type1", "type 2" and "type3".}
}
\value{
\code{changesAA} returns a list, where each entry belongs to one
taxon of interest. Each taxon of interest has a matrix assigned to it, in
which the first and second column contain the positions and types of the
identified diagnostic characters in the nucleotide alignment and the third
and fourth column contain the positions and types of the diagnostic
characters in the corresponding amino acid alignment.

\code{type1} means that the character is suitable to distinguish each
individual of the taxon of interest from all individuals of the remaining
taxa, and that it is fixed for one state in the taxon of interest.
\code{type2} means that the character is suitable to distinguish each
individual of the taxon of interest from all individuals of the remaining
taxa, and that it is not fixed for one state in the taxon of interest.
\code{type3} means that the character is suitable to distinguish some (but
not all) individuals of the taxon of interest from all individuals of the
remaining taxa.
\code{type4} means that the character is suitable to distinguish each
individual of the taxon of interest from all individuals of at least one
(but not all) other taxon while being fixed in both the taxon of interest
and the compared taxa.

\code{changesAA} returns for each taxon of interest the following elements:
\item{posDiNu}{The positions of the identified diagnostic characters in the
nucleotide alignment.}
\item{typeDiNu}{The types of the identified diagnostic characters in the
nucleotide alignment.}
\item{posDiAA}{The positions of the corresponding diagnostic characters in
the amino acid alignment.}
\item{typeDiAA}{The types of the corresponding diagnostic characters in the
amino acid alignment.}
}
\description{
This function is a tool for an automated identification of such diagnostic
molecular characters in a nucleotide alignment that also cause diagnostic
characters in the corresponding amino acid alignment. For each taxon given
in \code{taxOfInt}, it identifies the mentioned characters and returns their
positions and types in the nucleotide alignment and their positions and
types in the corresponding amino acid alignment.
}
\examples{
#using a dataset from spider
#install.packages("spider")
library(spider)
data("anoteropsis")
anoTax <- sapply(strsplit(dimnames(anoteropsis)[[1]], split="_"),
 function(x) paste(x[1], x[2], sep="_"))
changesAA(anoteropsis, anoTax, codonstart=2, taxOfInt="all")
changesAA(anoteropsis, anoTax, codonstart=2, taxOfInt="Artoria_flavimanus",
 types="type4")

}
\references{
Kuehn, A.L., Haase, M. (2019) QUIDDICH: QUick IDentification of
DIagnostic CHaracters.
}
\author{
A. Luise Kuehn <luise.kuehn@uni-greifswald.de>
}
