% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.3_Distr_DistrCollection_Functions.R
\name{cg}
\alias{cg}
\title{cg: Function to calculate and visualize the gage capability.}
\usage{
cg(
  x,
  target,
  tolerance,
  ref.interval,
  facCg,
  facCgk,
  n = 0.2,
  col,
  pch,
  xlim,
  ylim,
  conf.level = 0.95
)
}
\arguments{
\item{x}{A vector containing the measured values.}

\item{target}{A numeric value giving the expected target value for the x-values.}

\item{tolerance}{Vector of length 2 giving the lower and upper specification limits.}

\item{ref.interval}{Numeric value giving the confidence interval on which the calculation is based. By default it is based on 6 sigma methodology.
Regarding the normal distribution this relates to \code{pnorm(3) - pnorm(-3)} which is exactly 99.73002 percent. If the calculation is based on another sigma value \code{ref.interval} needs to be adjusted.
To give an example: If the sigma-level is given by 5.15 the \code{ref.interval} relates to \code{pnorm(5.15/2)-pnorm(-5.15/2)} which is exactly 0.989976 percent.}

\item{facCg}{Numeric value as a factor for the calculation of the gage potential index. The default value for \code{facCg} is \code{0.2}.}

\item{facCgk}{Numeric value as a factor for the calculation of the gage capability index. The default value for \code{facCgk} is \code{0.1}.}

\item{n}{Numeric value between \code{0} and \code{1} giving the percentage of the tolerance field (values between the upper and lower specification limits given by \code{tolerance}) where the values of \code{x} should be positioned. Limit lines will be drawn. Default value is \code{0.2}.}

\item{col}{Character or numeric value specifying the color of the curve in the run chart. Default is \code{`black`}.}

\item{pch}{Numeric or character specifying the plotting symbol. Default is \code{19} (filled circle).}

\item{xlim}{Numeric vector of length 2 specifying the limits for the x-axis. Default is \code{NULL} which means the limits are set automatically.}

\item{ylim}{Numeric vector of length 2 specifying the limits for the y-axis. Default is \code{NULL} which means the limits are set automatically.}

\item{conf.level}{Confidence level for internal \code{t.test} checking the significance of the bias between \code{target} and mean of \code{x}. The default value is \code{0.95}. The result of the \code{t.test} is shown in the histogram on the left side.}
}
\value{
The function \code{cg} returns a list of numeric values. The first element contains the calculated centralized gage potential index \code{Cg} and the second contains the non-centralized gage capability index \code{Cgk}.
}
\description{
Function visualize the given values of measurement in a run chart and in a histogram. Furthermore the \code{centralized Gage potential index} \code{Cg} and the \code{non-centralized Gage Capability index} \code{Cgk} are calculated and displayed.
}
\details{
The calculation of the potential and actual gage capability are based on the following formula:
\itemize{
\item{\code{Cg = (facCg * tolerance[2]-tolerance[1])/ref.interval}}
\item{\code{Cgk = (facCgk * abs(target-mean(x))/(ref.interval/2)}}
}
If the usage of the historical process variation is preferred the values for the tolerance \code{tolerance} must be adjusted manually. That means in case of the 6 sigma methodology for example, that \code{tolerance = 6 * sigma[process]}.
}
\examples{

x <- c(9.991, 10.013, 10.001, 10.007, 10.010, 10.013, 10.008,9.992,
       10.017, 10.005, 10.005, 10.002, 10.017, 10.005, 10.002, 9.996,
       10.011, 10.009, 10.006, 10.008, 10.003, 10.002, 10.006, 10.010, 10.013)

cg(x = x, target = 10.003, tolerance = c(9.903, 10.103))
}
\seealso{
\code{\link{cg_RunChart}}, \code{\link{cg_HistChart}}, \code{\link{cg_ToleranceChart}}.
}
