% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunogenicity_functions.R
\docType{methods}
\name{evalNorm}
\alias{evalNorm}
\alias{evalNorm,ImmunoAssay-method}
\title{Normality Evaluation}
\usage{
evalNorm(
  assay.obj,
  category = NULL,
  data.transf = FALSE,
  transf.method = c("log10", "ln"),
  excl.outliers = FALSE,
  hist = TRUE,
  p.val = 0.05,
  skew = 1,
  return.object = TRUE
)
}
\arguments{
\item{assay.obj}{An ImmunoAssay object imported by importAssay}

\item{category}{If assay.df.melted consists of more than 1 dataset, choose the category here to split dataset}

\item{data.transf}{Should the data should be transformed before normality is evaluated}

\item{transf.method}{If data.transf is TRUE, which method should be used. Can choose between 'log10' and 'ln'.}

\item{excl.outliers}{Should outliers be excluded from this analysis? If TRUE, data points which lie beyond the extremes of the whiskers in boxplot will be excluded, see boxplot.stats for details.}

\item{hist}{Should a histogram be outputted? TRUE/FALSE}

\item{p.val}{Value to be used for cutoff for Shapiro-Wilks test. Defaults to 0.05.}

\item{skew}{Value to be used to determine skewness. Defaults to 1.}

\item{return.object}{If FALSE, only the plot is returned and the stats are returned as a list.}
}
\value{
If \code{return.object==FALSE}, only the plot is returned and the stats are returned as a list. Otherwise, an object of the class ImmunoAssay is returned.
}
\description{
This function evaluates the normality of the melted immunoassay dataset. In order to determine whether or not the distribution is normal, two tests are performed: the Shapiro Wilk test for normality and the test for skewness. See \link[stats]{shapiro.test} and \link[e1071]{skewness} for details. In order to for a "nonparametric" recommendation to be made, the SW test must be significant (below desire value) and the absolute value skewness must be above the desired value. If only one or neither of these conditions are met, then the recommendation will be "normal".
}
\examples{
assay.obj <- importAssay(lognormAssay, exp.name = 'Experiment1')
assay.obj <- evalNorm(assay.obj, category = 'Experiment1',
data.transf = TRUE, transf.method = 'log10')


}
\author{
Emma Gail
}
